% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9FilterPoa}
\alias{icd9FilterPoa}
\alias{icd9FilterPoaNo}
\alias{icd9FilterPoaNotNo}
\alias{icd9FilterPoaNotYes}
\alias{icd9FilterPoaYes}
\title{filters data frame based on present-on-arrival flag}
\usage{
icd9FilterPoa(icd9df, poaField = "poa", poa = icd9PoaChoices)

icd9FilterPoaYes(icd9df, poaField = "poa")

icd9FilterPoaNo(icd9df, poaField = "poa")

icd9FilterPoaNotNo(icd9df, poaField = "poa")

icd9FilterPoaNotYes(icd9df, poaField = "poa")
}
\arguments{
\item{icd9df}{data frame containing columns for visitId (which is the feault name), icd9 (default for the icd9 code), and  maybe also a POA flag.}

\item{poaField}{The name of column in the data frame which contains the
Present On Arrival flag. The flag itself is a single character, typically
one of "Y", "N", "E", "X", "U" or empty. The poaField is a character vector
of length one.}

\item{poa}{single character value, being one of \code{poaChoices} whether to
account for co-morbidities flagged as present-on-arrival. This is not a
simple binary, since many codes are exempt, unspecified, or unknown.
\code{poaField} gives the choices: yes, not no, no, not yes. The
intermediate codes, such as "exempt", "unknown" and \code{NA} mean that
"yes" is not the same as "not no."}
}
\description{
this is not a simple binary, since many codes are exempt,
  unspecified, or unknown. Therefore, two options are given: get all the
  comorbidities where the POA flag was definitely -ve, coded as "N" or
  definitely +ve and coded as "Y". Negating one set won't give the other set
  unless all codes were either Y or N. #describeIn icd9Comorbidities
}
\examples{
\dontrun{
# using magrittr is beautiful:
library("magrittr", quietly = TRUE, warn.conflicts = FALSE)
myData <- data.frame(
  visitId = c("v1", "v2", "v3", "v4"),
  icd9 = c("39891", "39790", "41791", "4401"),
  poa = c("Y", "N", NA, "Y"),
  stringsAsFactors = FALSE
)
myData \%>\% icd9FilterPoaNotNo() \%>\% icd9ComorbiditiesAhrq(isShort = TRUE)
# can fill out named fields also:
myData \%>\% icd9FilterPoaYes(poaField="poa") \%>\%
  icd9ComorbiditiesAhrq(icd9Field = "icd9", visitId = "visitId")
# can call the core icd9Comorbidities function with an arbitrary mapping
myData \%>\%
icd9FilterPoaYes() \%>\%
icd9Comorbidities(icd9Field = "icd9", visitId = "visitId",
  icd9Mapping = quanElixhauserComorbid,
 validateMapping = TRUE,
 isShortMapping = TRUE)
}
}

