% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9Comorbidities}
\alias{icd9Comorbidities}
\alias{icd9ComorbiditiesAhrq}
\alias{icd9ComorbiditiesElixhauser}
\alias{icd9ComorbiditiesQuanDeyo}
\alias{icd9ComorbiditiesQuanElixhauser}
\title{find comorbidities from ICD-9 codes.}
\usage{
icd9Comorbidities(icd9df, visitId = "visitId", icd9Field = "icd9", isShort,
  icd9Mapping, validateMapping = FALSE, isShortMapping = TRUE)

icd9ComorbiditiesAhrq(icd9df, visitId = "visitId", icd9Field = "icd9",
  isShort, validateMapping = FALSE, abbrevNames = TRUE,
  applyHierarchy = TRUE)

icd9ComorbiditiesQuanDeyo(icd9df, visitId = "visitId", icd9Field = "icd9",
  isShort, validateMapping = FALSE, abbrevNames = TRUE,
  applyHierarchy = TRUE)

icd9ComorbiditiesQuanElixhauser(icd9df, visitId = "visitId",
  icd9Field = "icd9", isShort, validateMapping = FALSE,
  abbrevNames = TRUE, applyHierarchy = TRUE)

icd9ComorbiditiesElixhauser(icd9df, visitId = "visitId", icd9Field = "icd9",
  isShort, validateMapping = FALSE, abbrevNames = TRUE,
  applyHierarchy = TRUE)
}
\arguments{
\item{icd9df}{data frame containing columns for visitId (which is the feault name), icd9 (default for the icd9 code), and  maybe also a POA flag.}

\item{visitId}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. Defaults to "visitId"}

\item{icd9Field}{The column in the data frame which contains the ICD-9 codes.
This is a character vector of length one.}

\item{isShort}{single logical value which determines whether the ICD-9 code provided is in short (TRUE) or decimal (FALSE) form.}

\item{icd9Mapping}{list (or name of a list if character vector of length one
is given as argument) of the comorbidities with each top-level list item
containing a vector of decimal ICD9 codes. This is in the form of a list,
with the names of the items corresponding to the comorbidities (e.g. "HTN",
or "diabetes") and the contents of each list item being a character vector
of short-form (no decimal place but ideally zero left-padded) ICD-9 codes.
No default: user should prefer to use the derivative functions, e.g.
icd9ComorbiditiesAhrq, since these also provide appropriate naming for the
fields, and squashing the hierarchy (see \code{applyHierarchy} below)}

\item{validateMapping}{logical, whether to validate all the ICD-9 codes in
the mapping list. Default is not to check. If validation fails, stop with
an error. This is probably worth doing at least once for each mapping used,
since there should never be an error in mapping.}

\item{isShortMapping}{logical, whether the mapping is defined with short
ICD-9 codes (TRUE, the default), or decimal if set to FALSE.}

\item{abbrevNames}{single locical value that defaults to \code{TRUE}, in which
case the ishorter human-readable names stored in e.g. \code{ahrqComorbidNamesAbbrev}
are applied to the data frame column names.}

\item{applyHierarchy}{single logical value that defaults to \code{TRUE}, in
which case the hierarchy defined for the mapping is applied. E.g. in
Elixhauser, you can't have uncomplicated and complicated diabetes both
flagged.}
}
\description{
This is the main function which extracts co-morbidities from a
  set of ICD-9 codes. This is when some trivial post-processing of the
  comorbidity data is done, e.g. renaming to human-friendly field names, and
  updating fields according to rules. The exact fields from the original
  mappings can be obtained using \code{applyHierarchy = FALSE}, but for
  comorbidity counting, Charlson Score, etc., the rules should be applied.

For Charlson-based comorbidities, strictly speaking, there is no
  dropping of more e.g. uncomplicated DM if complicated DM exists, however,
  this is probaably useful, in general and is essential when calculating the
  Charlson score.
}

