% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doROCcurveMRMC.R
\name{doROCxy}
\alias{doROCxy}
\title{Create empirical ROC curve}
\usage{
doROCxy(sa, sp)
}
\arguments{
\item{sa}{signal-absent scores}

\item{sp}{signal-present scores}
}
\value{
data frame of an ROC curve
 \itemize{
  \item{\code{fpf} False-positive fractions (1-specificity)}
  \item{\code{tpf} True-positive fractions (sensitivity)}
  \item{\code{threshold} Threshold corresponding to each fpf, tpf
  operating point}
}
}
\description{
Create empirical ROC curve
}
\examples{
# Create a sample configuration file
config <- sim.gRoeMetz.config()
# Simulate an MRMC ROC data set
dFrame.imrmc <- sim.gRoeMetz(config)
# Isolate signal absent scores
indexSA <- grep("negCase", dFrame.imrmc$caseID)
sa <- dFrame.imrmc[indexSA, ]$score
# Isolate signal present scores
indexSP <- grep("posCase", dFrame.imrmc$caseID)
sp <- dFrame.imrmc[indexSP, ]$score
# Compute empirical ROC curve
result <- doROCxy(sa, sp)
}
