/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.util.Num;

public class StudentDistQuick
extends StudentDist {
    private static final int STUDENT_N1 = 20;
    private static final double STUDENT_X1 = 8.01;
    private static final int STUDENT_KMAX = 200;
    private static final double STUDENT_EPS = 5.0E-17;

    public StudentDistQuick(int n) {
        super(n);
    }

    public double cdf(double x) {
        return StudentDistQuick.cdf(this.n, x);
    }

    public double barF(double x) {
        return StudentDistQuick.barF(this.n, x);
    }

    public double inverseF(double u) {
        return StudentDistQuick.inverseF(this.n, u);
    }

    public static double cdf(int n, double x) {
        int k;
        if (n <= 2) {
            return StudentDist.cdf(n, x);
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (n <= 20 && x <= 8.01) {
            double b = 1.0 + x * x / (double)n;
            double y = x / Math.sqrt(n);
            double z = 1.0;
            for (int k2 = n - 2; k2 >= 2; k2 -= 2) {
                z = 1.0 + z * (double)(k2 - 1) / ((double)k2 * b);
            }
            double v = n % 2 == 0 ? (1.0 + z * y / Math.sqrt(b)) / 2.0 : (y > -1.0 ? 0.5 + (Math.atan(y) + z * y / b) / Math.PI : (Math.atan(-1.0 / y) + z * y / b) / Math.PI);
            if (v > 1.0E-18) {
                return v;
            }
            return 0.0;
        }
        if (x < 8.01) {
            double a = (double)n - 0.5;
            double b = 48.0 * a * a;
            double z2 = a * Math.log1p(x * x / (double)n);
            double z = Math.sqrt(z2);
            double y = (((((64.0 * z2 + 788.0) * z2 + 9801.0) * z2 + 89775.0) * z2 + 543375.0) * z2 + 1788885.0) * z / (210.0 * b * b * b);
            y -= (((4.0 * z2 + 33.0) * z2 + 240.0) * z2 + 855.0) * z / (10.0 * b * b);
            y += z + (z2 + 3.0) * z / b;
            if (x >= 0.0) {
                return NormalDist.barF01(-y);
            }
            return NormalDist.barF01(y);
        }
        double b = 1.0 + x * x / (double)n;
        double y = Num.gammaRatioHalf((double)n / 2.0);
        y *= 1.0 / (Math.sqrt(Math.PI * (double)n) * Math.pow(b, (double)(n + 1) / 2.0));
        double z = (y *= 2.0 * Math.sqrt((double)n * b)) / (double)n;
        double prec = 10.0;
        double z2 = 10.0;
        for (k = 2; k < 200 && prec > 5.0E-17; k += 2) {
            prec = Math.abs((z += (y *= (double)(k - 1) / ((double)k * b)) / (double)(n + k)) - z2);
            z2 = z;
        }
        if (k >= 200) {
            System.err.println("student: k >= STUDENT_KMAX");
        }
        if (x >= 0.0) {
            return 1.0 - z / 2.0;
        }
        return z / 2.0;
    }

    public static double barF(int n, double x) {
        if (n <= 2) {
            return StudentDist.barF(n, x);
        }
        return StudentDistQuick.cdf(n, -x);
    }

    public static double inverseF(int n, double u) {
        if (n <= 2) {
            return StudentDist.inverseF(n, u);
        }
        double PI = Math.PI;
        double e = n;
        double p = u > 0.5 ? 2.0 * (1.0 - u) : 2.0 * u;
        double a = 1.0 / (e - 0.5);
        double b = 48.0 / (a * a);
        double c = ((20700.0 / b * a - 98.0) * a - 16.0) * a + 96.36;
        double d = e * Math.sqrt(a * Math.PI / 2.0) * ((94.5 / (b + c) - 3.0) / b + 1.0);
        double y = Math.pow(d * p, 2.0 / e);
        if (y > a + 0.05) {
            double x = p == 1.0 ? 0.0 : NormalDist.inverseF01(p * 0.5);
            y = x * x;
            if (n < 5) {
                c += 0.3 * (e - 4.5) * (x + 0.6);
            }
            c = (((0.05 * d * x - 5.0) * x - 7.0) * x - 2.0) * x + b + c;
            y = (((((0.4 * y + 6.3) * y + 36.0) * y + 94.5) / c - y - 3.0) / b + 1.0) * x;
            y = a * (y * y);
            y = Math.expm1(y);
        } else {
            y = ((1.0 / (((e + 6.0) / (e * y) - 0.089 * d - 0.822) * (e + 2.0) * 3.0) + 0.5 / (e + 4.0)) * y - 1.0) * (e + 1.0) / (e + 2.0) + 1.0 / y;
        }
        double t = Math.sqrt(e * y);
        if (u < 0.5) {
            return -t;
        }
        return t;
    }
}

