% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARgamma.R
\name{IAR.gamma}
\alias{IAR.gamma}
\title{Maximum Likelihood Estimation of the IAR-Gamma model}
\usage{
IAR.gamma(y, sT)
}
\arguments{
\item{y}{Array with the time series observations}

\item{sT}{Array with the irregular observational times}
}
\value{
A list with the following components:
\itemize{
\item{phi}{ MLE of the phi parameter of the IAR-Gamma model.}
\item{mu}{ MLE of the mu parameter of the IAR-Gamma model.}
\item{sigma}{ MLE of the sigma parameter of the IAR-Gamma model.}
\item{ll}{ Value of the negative log likelihood evaluated in phi, mu and sigma.}
}
}
\description{
Maximum Likelihood Estimation of the IAR-Gamma model.
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
y<-IARg.sample(n,phi=0.9,st,sigma2=1,mu=1)
model<-IAR.gamma(y$y, sT=st)
phi=model$phi
muest=model$mu
sigmaest=model$sigma
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARg.sample}}, \code{\link{IAR.phi.gamma}}
}
