% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARtest.R
\name{IAR.Test}
\alias{IAR.Test}
\title{Test for the significance of the autocorrelation estimated by the IAR model in periodic irregularly observed time series}
\usage{
IAR.Test(y, sT, f, phi, plot = "TRUE", xlim = c(-1, 0))
}
\arguments{
\item{y}{Array with the time series observations}

\item{sT}{Array with the irregular observational times}

\item{f}{Frequency (1/Period) of the raw time series}

\item{phi}{autocorrelation estimated by \code{\link{IAR.loglik}}}

\item{plot}{logical; if true, the function return a density plot of the distribution of the bad fitted examples; if false, this function does not return a plot}

\item{xlim}{The x-axis limits (x1, x2) of the plot. Only works if plot='TRUE'. See \code{\link{plot.default}} for more details}
}
\value{
A list with the following components:
\itemize{
\item{phi}{ MLE of the phi parameter of the IAR model.}
\item{norm}{ Mean and variance of the normal distribution of the bad fitted examples.}
\item{z0}{ Statistic of the test (log(phi)).}
\item{pvalue}{ P-value computed for the test.}
}
}
\description{
This function perform a test for the significance of the autocorrelation estimated by the IAR model. This test is based on the residuals of the periodical time series fitted with an harmonic model using an incorrect period.
}
\details{
The null hypothesis of the test is: The autocorrelation estimated in the time series belongs to the distribution of the coefficients estimated for the residuals of the data fitted using wrong periods. Therefore, if the hypothesis is rejected, it can be concluded that the residuals of the harmonic model do not remain a time dependency structure.The statistic of the test is log(phi) which was contrasted with a normal distribution with parameters corresponding to the log of the mean and the variance of the phi computed for the residuals of the bad fitted light curves.
}
\examples{
data(clcep)
f1=0.060033386
results=harmonicfit(file=clcep,f1=f1)
y=results$res/sqrt(var(results$res))
sT=results$t
res3=IAR.loglik(y,sT,standarized='TRUE')[1]
res3$phi
require(ggplot2)
test<-IAR.Test(y=clcep[,2],sT=clcep[,1],f1,res3$phi,plot='TRUE',xlim=c(-10,0.5))
test
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{clcep}}, \code{\link{harmonicfit}}, \code{\link{IAR.loglik}}, \code{\link{IAR.Test2}}
}
