% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIARphikalman.R
\name{BIAR.phi.kalman}
\alias{BIAR.phi.kalman}
\title{Minus Log Likelihood of the BIAR Model}
\usage{
BIAR.phi.kalman(x, y1, y2, t, yerr1, yerr2, zero.mean = "TRUE")
}
\arguments{
\item{x}{An array with the parameters of the BIAR model. The elements of the array are, in order, the real (phi.R) and the imaginary (phi.I) part of the coefficient of BIAR model.}

\item{y1}{Array with the observations of the first time series of the BIAR process.}

\item{y2}{Array with the observations of the second time series of the BIAR process.}

\item{t}{Array with the irregular observational times.}

\item{yerr1}{Array with the measurements error standard deviations of the first time series of the BIAR process.}

\item{yerr2}{Array with the measurements error standard deviations of the second time series of the BIAR process.}

\item{zero.mean}{logical; if true, the array y has zero mean; if false, y has a mean different from zero.}
}
\value{
Value of the negative log likelihood evaluated in phiR and phiI.
}
\description{
This function return the negative log likelihood of the BIAR process given specific values of phi.R and phi.I
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
x=BIAR.sample(n=n,phi.R=0.9,phi.I=0.3,sT=st)
y=x$y
y1=y[1,]
y2=y[2,]
yerr1=rep(0,n)
yerr2=rep(0,n)
BIAR.phi.kalman(x=c(0.8,0.2),y1=y1,y2=y2,t=st,yerr1=yerr1,yerr2=yerr2)
}
\seealso{
\code{\link{gentime}}, \code{\link{BIAR.sample}}
}
