% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARsample.R
\name{IAR.sample}
\alias{IAR.sample}
\title{Simulate from an IAR(1) Model}
\usage{
IAR.sample(phi, n = 100, sT)
}
\arguments{
\item{phi}{A coefficient of IAR(1) model. A value between 0 and 1}

\item{n}{Length of the output time series. A strictly positive integer.}

\item{sT}{Array with observational times.}
}
\value{
A list with the following components:
\itemize{
\item{times}{ Array with observation times.}
\item{series}{ Array with simulated IAR(1) data.}
}
}
\description{
Simulates an IAR(1) Time Series Model.
}
\examples{

set.seed(6714)
st<-gentime(n=100)
y<-IAR.sample(phi=0.99,n=100,st)
y<-y$series
plot(st,y,type='l')

}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}
}
