% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hs_search.R
\name{hs_search_all}
\alias{hs_search_all}
\title{Retreive all annotation search results as a data frame}
\usage{
hs_search_all(sort = "updated", order = "asc", uri = NULL, user = NULL,
  text = NULL, any = NULL, custom = list(), pagesize = 200,
  progress = interactive())
}
\arguments{
\item{sort}{Character. Specify which field the annotations should be sorted
by: \code{consumer}, \code{created}, \code{id}, \code{text},
\code{updated}, \code{uri}, \code{user}.}

\item{order}{Character. Specify which order annotations should be sorted by:
\code{asc} or \code{desc}.}

\item{uri}{Character. Search for annotations of a particular URI, for example
\code{www.example.com}. URI searches will also find annotations of
equivalent URIs. For example if the HTML document at
\code{http://www.example.com/document.html?} includes a \code{<link
rel="canonical" href="http://www.example.com/canonical_document.html">}
then annotations of \code{http://www.example.com/canonical_document.html}
will also be included in the search results. Other forms of document
equivalence that are supported include \code{rel="alternate"} links, DOIs,
PDF file IDs, and more.}

\item{user}{Character. Search for annotations by a particular user. For
example, \code{tim} will find all annotations by users named \code{tim} at
any provider, while \code{tim@hypothes.is} will only find annotations by
\code{tim} on \code{hypothes.is}}

\item{text}{Character. Search for annotations whose body text contains some
text, for example: \code{foobar}.}

\item{any}{Character. Search for annotations whose \code{quote}, \code{tags},
\code{text}, \code{uri.parts} or \code{user} fields match some query text.}

\item{custom}{A named list of any field in the results returned by
hypothes.is as a name, and the search text as values.}

\item{pagesize}{Integer. How many annotations to retrieve per query. Between 1 and 200. (Default: 200)}

\item{progress}{Boolean. Should a progress bar be displayed during download?}
}
\value{
A dataframe with annotation data.
}
\description{
Takes the same arguments as \link{hs_search} and pages through all available
results, formatting the output as a data.frame.
}
\examples{
\dontrun{
hs_search_all(text = "arxiv")
}
}

