% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/like.R
\name{rmlike}
\alias{rmlike}
\title{Likelihood inference for random mating}
\usage{
rmlike(nvec, thresh = 1)
}
\arguments{
\item{nvec}{A vector containing the observed genotype counts,
where \code{nvec[[i]]} is the number of individuals with genotype
\code{i-1}. This should be of length \code{ploidy+1}.}

\item{thresh}{All groups with counts less than \code{nvec} will
be aggregated together.}
}
\value{
A list with the following elements:
\describe{
\item{\code{p}}{The estimated gamete genotype frequencies. \code{p[[i]]}
is the estimated frequency for gamete genotype \code{i-1}.}
\item{\code{chisq_rm}}{The likelihood ratio test statistic for testing
against the null of random mating.}
\item{\code{df_rm}}{The degrees of freedom associated with
\code{chisq_rm}.}
\item{\code{p_rm}}{The p-value against the null of random mating.}
}
}
\description{
Estimates gamete genotype frequencies using a maximum likelihood approach
and runs a likelihood ratio test for random mating.
}
\details{
Let \code{q} be the genotype frequencies. Let \code{p} be the gamete
frequencies. Then random mating occurs if
\code{q == stats::convolve(p, rev(p), type = "open")}. We test for
this hypothesis using likelihood inference, while estimating \code{p}.
}
\examples{
## Randomly generate gamete frequencies
set.seed(1)
ploidy <- 10
pvec <- stats::runif(ploidy / 2 + 1)
pvec <- pvec / sum(pvec)

## Genotype frequencies from gamete frequencies under random mating
qvec <- stats::convolve(pvec, rev(pvec), type = "open")

## Generate data
nvec <- c(stats::rmultinom(n = 1, size = 100, prob = qvec))

## Run rmlike()
rmlike(nvec = nvec)

}
\author{
David Gerard
}
