% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poleInaccessibility2.R
\name{poleInaccessibility}
\alias{poleInaccessibility}
\alias{poleInaccessibility2}
\alias{poleInaccessibility3}
\title{Find a binary pole of inaccessibility}
\usage{
poleInaccessibility2(x = NULL, y = NULL, DT = NULL, x_range = NULL,
  y_range = NULL, copy_DT = TRUE)

poleInaccessibility3(x = NULL, y = NULL, DT = NULL, x_range = NULL,
  y_range = NULL, copy_DT = TRUE, test_both = TRUE)
}
\arguments{
\item{x, y}{Coordinates.}

\item{DT}{A \code{data.table} containing \code{LONGITUDE} and \code{LATITUDE} to define
the \code{x} and \code{y} coordinates.}

\item{x_range, y_range}{Numeric vectors of length-2; the range of \code{x} and \code{y}.
Use this rather than the default when the 'vicinity' of \code{x,y} is different from
the minimum closed rectangle covering the points.}

\item{copy_DT}{(logical, default: \code{TRUE}) Run \code{\link[data.table]{copy}} on \code{DT}
before proceeding. If \code{FALSE}, \code{DT} have additional columns updated by reference.}

\item{test_both}{(logical, default: \code{TRUE}) For \code{3}, test both stretching vertically
then horizontally and horizontally then vertically.}
}
\value{
\describe{
\item{\code{poleInaccessibility2}}{
A named vector containing the
\code{xmin}, \code{xmax} and
\code{ymin}, \code{ymax} coordinates of
the largest rectangle of width an integer power of two that is empty.}
\item{\code{poleInaccessibility3}}{
Starting with the rectangle formed by \code{poleInaccessibility2},
the rectangle formed by stretching it out vertically and horizontally until
the edges intersect the points \code{x,y}
}
}
}
\description{
Find a binary pole of inaccessibility
}
\examples{
library(data.table)
library(hutils)
# A square with a 10 by 10 square of the northeast corner removed
x <- runif(1e4, 0, 100)
y <- runif(1e4, 0, 100)
DT <- data.table(x, y)
# remove the NE corner
DT_NE <- DT[implies(x > 90, y < 89)]
DT_NE[, poleInaccessibility2(x, y)]
DT_NE[, poleInaccessibility3(x, y)]

}
