% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pminC.R
\name{pminC}
\alias{pminC}
\alias{pmin0}
\alias{pminV}
\alias{pmin3}
\title{Parallel minimum}
\usage{
pmin0(x, in_place = FALSE)

pminV(x, y, in_place = FALSE)

pminC(x, a = 0, in_place = FALSE)

pmin3(x, y, z, in_place = FALSE)
}
\arguments{
\item{x}{A numeric vector.}

\item{in_place}{(logical, default: \code{FALSE}) Should \code{x}
be modified in-place.}

\item{y, z}{Other numeric vectors.}

\item{a}{A single number.}
}
\value{
Same as \code{pmin(x, 0)}.

\code{pmin0(x) = pmin(x, 0)}

\code{pminV(x, y) = pmin(x, y)}

\code{pminC(x, a) = pmin(x, a)}  for length-one \code{a}.

\code{pmin3(x, y, z) = pmin(x, pmin(y, z))}.
}
\description{
Parallel minimum
}
\details{
The type of \code{x} is preserved as far as possible.
}
\examples{
pminV(10:1, 1:10)
pmin0(-5:5)
seq_out <- function(x, y) seq(x, y, length.out = 10)
pmin3(seq_out(0, 10), seq_out(-5, 50), seq_out(20, -10))

}
