% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmaxC.R
\name{pmaxC}
\alias{pmaxC}
\alias{pmax0}
\alias{pmaxV}
\alias{pmax3}
\title{Parallel maximum/minimum}
\usage{
pmaxC(x, a, in_place = FALSE)

pmax0(x, in_place = FALSE)

pmaxV(x, y, in_place = FALSE)

pmax3(x, y, z, in_place = FALSE)
}
\arguments{
\item{x}{A numeric vector.}

\item{a}{A single numeric value.}

\item{in_place}{(logical, default: \code{FALSE}) Should \code{x}
be modified in-place.}

\item{y, z}{Other numeric vectors the same length as \code{x}}
}
\value{
The parallel maximum/minimum of the input values. \code{pmax0(x)} is
shorthand for \code{pmaxC(x, 0)}, i.e. convert negative values in \code{x} to 0.
}
\description{
Faster \code{pmax()} and \code{pmin()}.
}
\note{
This function will always be faster than \code{pmax(x, a)} when \code{a} is
a single value, but can be slower than \code{pmax.int(x, a)} when \code{x} is short.
Use this function when comparing a numeric vector with a single value.

Use \code{in_place = TRUE} within functions when you are sure it is safe.
}
\examples{
pmaxC(-5:5, 2)

}
