% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc.R
\name{create_yaxis}
\alias{create_yaxis}
\title{Creating multiples yAxis for add a highcharts}
\usage{
create_yaxis(naxis = 2, heights = 1, sep = 0.01, offset = 0,
  turnopposite = TRUE, ...)
}
\arguments{
\item{naxis}{Number of axis an integer.}

\item{heights}{A numeric vector. This values will be normalized.}

\item{sep}{A numeric value for the separation (in percentage) for the panes.}

\item{offset}{A numeric value (in percentage).}

\item{turnopposite}{A logical value to turn the side of each axis or not.}

\item{...}{Arguments defined in \url{http://api.highcharts.com/highcharts#yAxis}.}
}
\description{
Creating multiples yAxis for add a highcharts
}
\examples{

highchart() \%>\% 
   hc_yAxis_multiples(create_yaxis(naxis = 2, heights = c(2, 1))) \%>\% 
   hc_add_series(data = c(1,3,2), yAxis = 0) \%>\% 
   hc_add_series(data = c(20, 40, 10), yAxis = 1)
   

highchart() \%>\% 
  hc_yAxis_multiples(create_yaxis(naxis = 3, lineWidth = 2, title = list(text = NULL))) \%>\% 
  hc_add_series(data = c(1,3,2)) \%>\% 
  hc_add_series(data = c(20, 40, 10), yAxis = 1) \%>\% 
  hc_add_series(data = c(200, 400, 500), type = "column", yAxis = 2) \%>\% 
  hc_add_series(data = c(500, 300, 400), type = "column", yAxis = 2)  
   
}

