% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch-methods.R
\name{batch.future_chat}
\alias{batch.future_chat}
\title{Process a batch of prompts with a parallel chat}
\usage{
batch.future_chat(
  chat_env,
  prompts,
  type_spec = NULL,
  judgements = 0,
  state_path = tempfile("chat_", fileext = ".rds"),
  workers = NULL,
  chunk_size = parallel::detectCores() * 5,
  plan = "multisession",
  max_chunk_attempts = 3L,
  max_retries = 3L,
  initial_delay = 20,
  max_delay = 80,
  backoff_factor = 2,
  beep = TRUE,
  progress = TRUE,
  echo = FALSE,
  ...
)
}
\arguments{
\item{chat_env}{The chat environment from chat_future}

\item{prompts}{List of prompts to process}

\item{type_spec}{Type specification for structured data extraction}

\item{judgements}{Number of judgements for structured data extraction resulting in refined data}

\item{state_path}{Path to save state file}

\item{workers}{Number of parallel workers}

\item{chunk_size}{Number of prompts each worker processes at a time}

\item{plan}{Parallel backend ("multisession" or "multicore")}

\item{max_chunk_attempts}{Maximum retries per failed chunk}

\item{max_retries}{Maximum number of retry attempts for failed requests}

\item{initial_delay}{Initial delay before first retry in seconds}

\item{max_delay}{Maximum delay between retries in seconds}

\item{backoff_factor}{Factor to multiply delay by after each retry}

\item{beep}{Whether to play a sound on completion}

\item{progress}{Whether to show progress bars}

\item{echo}{Whether to display chat outputs (when \code{progress} is \code{FALSE})}

\item{...}{Additional arguments passed to the chat method}
}
\value{
A batch object with the processed results
}
\description{
Process a batch of prompts with a parallel chat
}
