% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabular_input.R
\name{create_matrix_from_tabular}
\alias{create_matrix_from_tabular}
\title{Create a Transition Matrix From Tabular Input}
\usage{
create_matrix_from_tabular(trans_probs, state_names,
  df_env = globalenv())
}
\arguments{
\item{trans_probs}{Result for one model of
\code{\link[=parse_multi_spec]{parse_multi_spec()}}.}

\item{state_names}{The names of the states used in the
transition matrix.}

\item{df_env}{An environment containing external data.}
}
\value{
A transition matrix.
}
\description{
Transforms tabular input defining a transition matrix
into an \code{heemod} object.
}
\details{
The data frame \code{trans_probs} should have columns
\code{from}, \code{to}, and \code{prob}, where
\code{prob} is the probability of a transition from the
\code{from} state to the \code{to} state. Prob can be
defined in terms of parameters, just as when using
\code{define_transition} at the keyboard. Probabilities of 0
need not be specified - they will be automatically
inserted.

All state names must be used in the \code{from} column of
the transition matrix (otherwise you can just get rid of
the state). Absorbing states should have a transition
from and to themselves with probability 1.
}
\keyword{internal}
