% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_halk.R
\name{make_alk}
\alias{make_alk}
\title{Make an age-length key out of length-at-age data}
\usage{
make_alk(
  laa_data,
  sizecol = "length",
  autobin = TRUE,
  binwidth = 1,
  agecol = "age",
  min_age = NULL,
  plus_group = NULL,
  numcol = NULL,
  min_age_sample_size = 5,
  min_total_sample_size = min_age_sample_size * min_age_groups,
  min_age_groups = 5,
  warnings = TRUE
)
}
\arguments{
\item{laa_data}{A data.frame with length-at-age data}

\item{sizecol}{Character string naming the column that holds size data}

\item{autobin}{Logical. Should the function automatically assign length bins
(default is TRUE)}

\item{binwidth}{Numeric. If \code{autobin = TRUE} this is the width for the
size bins}

\item{agecol}{Character string naming the column that holds age data}

\item{min_age}{Numeric. All ages less than this value will not be used in
ALK}

\item{plus_group}{Numeric value of the oldest age to include in the ALK. All
older individuals will be included in this plus group}

\item{numcol}{Character string naming the column that holds numbers data}

\item{min_age_sample_size}{Only applicable to alk models. The minimum
number of samples that must be in each age group in order to create an alk}

\item{min_total_sample_size}{Only applicable to alk models. The minimum
number of samples that must be in data in order to create an alk}

\item{min_age_groups}{Only applicable to alk models. The minimum number of
age groups that must be in data in order to create an alk}

\item{warnings}{Logical. Display warnings (TRUE, default)}
}
\value{
A data.frame containing the proportions of records for each size
that are at each age.
}
\description{
Make an age-length key out of length-at-age data
}
\examples{
make_alk(laa_data)
}
