% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igt_vpp.R
\name{igt_vpp}
\alias{igt_vpp}
\title{Value-Plus-Perseverance}
\usage{
igt_vpp(
  data = NULL,
  niter = 4000,
  nwarmup = 1000,
  nchain = 4,
  ncore = 1,
  nthin = 1,
  inits = "vb",
  indPars = "mean",
  modelRegressor = FALSE,
  vb = FALSE,
  inc_postpred = FALSE,
  adapt_delta = 0.95,
  stepsize = 1,
  max_treedepth = 10,
  ...
)
}
\arguments{
\item{data}{Data to be modeled. It should be given as a data.frame object,
a filepath for a tab-seperated txt file, \code{"example"} to use example data, or
\code{"choose"} to choose data with an interactive window.
Columns in the dataset must include:
"subjID", "choice", "gain", "loss". See \bold{Details} below for more information.}

\item{niter}{Number of iterations, including warm-up. Defaults to 4000.}

\item{nwarmup}{Number of iterations used for warm-up only. Defaults to 1000.}

\item{nchain}{Number of Markov chains to run. Defaults to 4.}

\item{ncore}{Number of CPUs to be used for running. Defaults to 1.}

\item{nthin}{Every \code{i == nthin} sample will be used to generate the posterior distribution.
Defaults to 1. A higher number can be used when auto-correlation within the MCMC sampling is
high.}

\item{inits}{Character value specifying how the initial values should be generated.
Possible options are "vb" (default), "fixed", "random", or your own initial values.}

\item{indPars}{Character value specifying how to summarize individual parameters. Current options
are: "mean", "median", or "mode".}

\item{modelRegressor}{Whether to export model-based regressors (\code{TRUE} or \code{FALSE}).
Not available for this model.}

\item{vb}{Use variational inference to approximately draw from a posterior distribution. Defaults
to \code{FALSE}.}

\item{inc_postpred}{Include trial-level posterior predictive simulations in model output (may greatly increase file
size). Defaults to \code{FALSE}.
If set to \code{TRUE}, it includes: "y_pred"}

\item{adapt_delta}{Floating point value representing the target acceptance probability of a new
sample in the MCMC chain. Must be between 0 and 1. See \bold{Details} below.}

\item{stepsize}{Integer value specifying the size of each leapfrog step that the MCMC sampler can
take on each new iteration. See \bold{Details} below.}

\item{max_treedepth}{Integer value specifying how many leapfrog steps the MCMC sampler can take
on each new iteration. See \bold{Details} below.}

\item{...}{For this model, it's possible to set \strong{model-specific argument(s)} as follows: 
\describe{
  \item{payscale}{Raw payoffs within data are divided by this number. Used for scaling data. Defaults to 100.}
  
  
  
  
  
  
  
  
}}
}
\value{
A class "hBayesDM" object \code{modelData} with the following components:
\describe{
  \item{model}{Character value that is the name of the model (\\code{"igt_vpp"}).}
  \item{allIndPars}{Data.frame containing the summarized parameter values (as specified by
    \code{indPars}) for each subject.}
  \item{parVals}{List object containing the posterior samples over different parameters.}
  \item{fit}{A class \code{\link[rstan]{stanfit}} object that contains the fitted Stan
    model.}
  \item{rawdata}{Data.frame containing the raw data used to fit the model, as specified by
    the user.}
  
  
  \item{modelRegressor}{List object containing the extracted model-based regressors.}
}
}
\description{
Hierarchical Bayesian Modeling of the Iowa Gambling Task using Value-Plus-Perseverance.
It has the following parameters: \code{A} (learning rate), \code{alpha} (outcome sensitivity), \code{cons} (response consistency), \code{lambda} (loss aversion), \code{epP} (gain impact), \code{epN} (loss impact), \code{K} (decay rate), \code{w} (RL weight).

\itemize{
  \item \strong{Task}: Iowa Gambling Task (Ahn et al., 2008)
  \item \strong{Model}: Value-Plus-Perseverance (Worthy et al., 2013)
}
}
\details{
This section describes some of the function arguments in greater detail.

\strong{data} should be assigned a character value specifying the full path and name (including
  extension information, e.g. ".txt") of the file that contains the behavioral data-set of all
  subjects of interest for the current analysis. The file should be a \strong{tab-delimited} text
  file, whose rows represent trial-by-trial observations and columns represent variables.\cr
For the Iowa Gambling Task, there should be 4 columns of data with the
  labels "subjID", "choice", "gain", "loss". It is not necessary for the columns to be in this particular order,
  however it is necessary that they be labeled correctly and contain the information below:
\describe{
  \item{subjID}{A unique identifier for each subject in the data-set.}
  \item{choice}{Integer indicating which deck was chosen on that trial (where A==1, B==2, C==3, and D==4).}
  \item{gain}{Floating point value representing the amount of currency won on that trial (e.g. 50, 100).}
  \item{loss}{Floating point value representing the amount of currency lost on that trial (e.g. 0, -50).}
  
  
  
  
  
}
\strong{*}Note: The file may contain other columns of data (e.g. "ReactionTime", "trial_number",
  etc.), but only the data within the column names listed above will be used during the modeling.
  As long as the necessary columns mentioned above are present and labeled correctly, there is no
  need to remove other miscellaneous data columns.

\strong{nwarmup} is a numerical value that specifies how many MCMC samples should not be stored
  upon the beginning of each chain. For those familiar with Bayesian methods, this is equivalent
  to burn-in samples. Due to the nature of the MCMC algorithm, initial values (i.e. where the
  sampling chains begin) can have a heavy influence on the generated posterior distributions. The
  \code{nwarmup} argument can be set to a high number in order to curb the effects that initial
  values have on the resulting posteriors.

\strong{nchain} is a numerical value that specifies how many chains (i.e. independent sampling
  sequences) should be used to draw samples from the posterior distribution. Since the posteriors
  are generated from a sampling process, it is good practice to run multiple chains to ensure
  that a reasonably representative posterior is attained. When the sampling is complete, it is
  possible to check the multiple chains for convergence by running the following line of code:
  \code{plot(output, type = "trace")}. The trace-plot should resemble a "furry caterpillar".

\strong{nthin} is a numerical value that specifies the "skipping" behavior of the MCMC sampler,
  using only every \code{i == nthin} samples to generate posterior distributions. By default,
  \code{nthin} is equal to 1, meaning that every sample is used to generate the posterior.

\strong{Control Parameters:} \code{adapt_delta}, \code{stepsize}, and \code{max_treedepth} are
  advanced options that give the user more control over Stan's MCMC sampler. It is recommended
  that only advanced users change the default values, as alterations can profoundly change the
  sampler's behavior. Refer to 'The No-U-Turn Sampler: Adaptively Setting Path Lengths in
  Hamiltonian Monte Carlo (Hoffman & Gelman, 2014, Journal of Machine Learning Research)' for
  more information on the sampler control parameters. One can also refer to 'Section 34.2. HMC
  Algorithm Parameters' of the \href{https://mc-stan.org/users/documentation/}{Stan User's Guide
  and Reference Manual}, or to the help page for \code{\link[rstan]{stan}} for a less technical
  description of these arguments.
}
\examples{
\dontrun{
# Run the model with a given data.frame as df
output <- igt_vpp(
  data = df, niter = 2000, nwarmup = 1000, nchain = 4, ncore = 4)

# Run the model with example data
output <- igt_vpp(
  data = "example", niter = 2000, nwarmup = 1000, nchain = 4, ncore = 4)

# Visually check convergence of the sampling chains (should look like 'hairy caterpillars')
plot(output, type = "trace")

# Check Rhat values (all Rhat values should be less than or equal to 1.1)
rhat(output)

# Plot the posterior distributions of the hyper-parameters (distributions should be unimodal)
plot(output)

# Show the WAIC and LOOIC model fit estimates
printFit(output)
}
}
\references{
Ahn, W. Y., Busemeyer, J. R., & Wagenmakers, E. J. (2008). Comparison of decision learning models using the generalization criterion method. Cognitive Science, 32(8), 1376-1402. https://doi.org/10.1080/03640210802352992

Worthy, D. A., & Todd Maddox, W. (2013). A comparison model of reinforcement-learning and win-stay-lose-shift decision-making processes: A tribute to W.K. Estes. Journal of Mathematical Psychology, 59, 41-49. https://doi.org/10.1016/j.jmp.2013.10.001
}
\seealso{
We refer users to our in-depth tutorial for an example of using hBayesDM:
  \url{https://rpubs.com/CCSL/hBayesDM}
}
