% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CommonFG-DataSet.R
\docType{methods}
\name{CommonFG-DataSet}
\alias{CommonFG-DataSet}
\alias{createDataSet}
\alias{createDataSet,CommonFG,character,missing,character,ANY,ANY,ANY,ANY,ANY-method}
\alias{createDataSet,CommonFG,character,ANY,missing,missing,ANY,ANY,ANY,numeric-method}
\alias{createDataSet,CommonFG,character,ANY,missing,missing,ANY,ANY,ANY,missing-method}
\alias{openDataSet}
\alias{openDataSet,CommonFG,character-method}
\alias{list.datasets}
\alias{list.datasets,CommonFG-method}
\alias{existsDataSet}
\alias{existsDataSet,CommonFG,character-method}
\title{Functions to Create/Open DataSets in \code{\link{CommonFG}} objects                               
                                                                             
Although \code{\link{DataSet}} objects can implicitly be created using 
subsetting operators (see \code{\link{CommonFG}}) \pkg{h5} implements more
explicit functions (used by subsetting operators under the hood) to create 
and open \code{\link{DataSet}s}.}
\usage{
createDataSet(.Object, datasetname, data, type, dimensions, chunksize = -1,
  maxdimensions = NA_integer_, compression = 4L, size = -1)


  \S4method{createDataSet}{CommonFG,character,missing,character,ANY,ANY,ANY,ANY,ANY}(.Object,
  datasetname, type, dimensions, chunksize, maxdimensions, compression, size)


  \S4method{createDataSet}{CommonFG,character,ANY,missing,missing,ANY,ANY,ANY,numeric}(.Object,
  datasetname, data, chunksize, maxdimensions, compression, size)


  \S4method{createDataSet}{CommonFG,character,ANY,missing,missing,ANY,ANY,ANY,missing}(.Object,
  datasetname, data, chunksize, maxdimensions, compression)

openDataSet(.Object, datasetname, type)

\S4method{openDataSet}{CommonFG,character}(.Object, datasetname, type)

list.datasets(.Object, path = "/", full.names = TRUE, recursive = TRUE,
  follow.links = FALSE)

\S4method{list.datasets}{CommonFG}(.Object, path = "/", full.names = TRUE,
  recursive = TRUE, follow.links = FALSE)

existsDataSet(.Object, datasetname)

\S4method{existsDataSet}{CommonFG,character}(.Object, datasetname)
}
\arguments{
\item{.Object}{CommonFG; S4 object of class \code{CommonFG};}

\item{datasetname}{character; HDF5 DataSet name to be used.}

\item{data}{object; Object to be stored in HDF5 file, can be either of type
vector, matrix or array.}

\item{type}{character; Character specifying data type, can be either one of:
   \describe{                                                                  
       \item{double}{Double precision floating--point number.}                              
       \item{integer}{32--Bit integer.}                                            
       \item{logical}{Boolean, which is mapped to 1/0 integer values.}           
       \item{character}{Variable--length character strings.}                      
}}

\item{dimensions}{integer; Dimensions of dataset to be created.}

\item{chunksize}{integer; Chunksize to be used for dataset. If set to 
\code{NA}, chunking is disabled for dataset; \code{maxdimensionions} and 
\code{compression} have no effect and extensions of DataSet (e.g. through 
\code{cbind}, \code{rbind}) are not possible.}

\item{maxdimensions}{integer; Maximum dimensions used for dataset, \code{NA} 
sets maxdimensions to 'unlimited'.}

\item{compression}{integer; Default GZIP compression level to be used, from
0 (no compression) to 9 (maximum compression), defaults to \code{4}.}

\item{size}{numeric; Character length for fixed-length string data types.
Default value of -1 creates variable-length strings.}

\item{path}{character; Relative path to .Object.}

\item{full.names}{character; Specify if absolute DataSet path names should be
returned.}

\item{recursive}{logical; Specify DatSets should be retrieved recursively
from .Object.}

\item{follow.links}{logical; Specify if symbolic links should be followed 
(only applies if recursive = TRUE).}
}
\description{
Functions to Create/Open DataSets in \code{\link{CommonFG}} objects                               
                                                                             
Although \code{\link{DataSet}} objects can implicitly be created using 
subsetting operators (see \code{\link{CommonFG}}) \pkg{h5} implements more
explicit functions (used by subsetting operators under the hood) to create 
and open \code{\link{DataSet}s}.
}
