% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvstore.R
\name{h2o.removeAll}
\alias{h2o.removeAll}
\title{Remove All Objects on the H2O Cluster}
\usage{
h2o.removeAll(timeout_secs = 0, retained_elements = c())
}
\arguments{
\item{timeout_secs}{Timeout in seconds. Default is no timeout.}

\item{retained_elements}{Instances or ids of models and frames to be retained. Combination of instances and ids in the same list is also a valid input.}
}
\description{
Removes the data from the h2o cluster, but does not remove the local references.
Retains models, frames and vectors specified in retained_elements argument.
Retained elements must be instances/ids of models and frames only. For models retained, training and validation frames are retained as well.
Cross validation models of a retained model are NOT retained automatically, those must be specified explicitely.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
h2o.ls()
h2o.removeAll()
h2o.ls()
}
}
\seealso{
\code{\link{h2o.rm}}
}
