% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.sdev}
\alias{h2o.sdev}
\title{Retrieve the standard deviations of principal components}
\usage{
h2o.sdev(object)
}
\arguments{
\item{object}{An \linkS4class{H2ODimReductionModel} object.}
}
\description{
Retrieve the standard deviations of principal components
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv"
cars <- h2o.importFile(f)
predictors <- c("displacement", "power", "weight", "acceleration", "year")
cars_pca <- h2o.prcomp(cars, transform = "STANDARDIZE", 
                       k = 3, x = predictors, seed = 12345)
h2o.sdev(cars_pca)
}
}
