% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{h2o.train_segments}
\alias{h2o.train_segments}
\title{H2O Segmented-Data Bulk Model Training}
\usage{
h2o.train_segments(
  algorithm,
  segment_columns,
  segment_models_id,
  parallelism = 1,
  ...
)
}
\arguments{
\item{algorithm}{Name of algorithm to use in training segment models (gbm, randomForest, kmeans, glm, deeplearning, naivebayes, psvm,
xgboost, pca, svd, targetencoder, aggregator, word2vec, coxph, isolationforest, kmeans, stackedensemble, glrm, gam).}

\item{segment_columns}{A list of columns to segment-by. H2O will group the training (and validation) dataset by the segment-by columns
and train a separate model for each segment (group of rows).}

\item{segment_models_id}{Identifier for the returned collection of Segment Models. If not specified it will be automatically generated.}

\item{parallelism}{Level of parallelism of bulk model building, it is the maximum number of models each H2O node will be building in parallel, defaults to 1.}

\item{...}{Use to pass along training_frame parameter, x, y, and all non-default parameter values to the algorithm 
Look at the specific algorithm - h2o.gbm, h2o.glm, h2o.kmeans, h2o.deepLearning - for available parameters.}
}
\description{
Provides a set of functions to train a group of models on different
segments (subpopulations) of the training set.
}
\details{
Start Segmented-Data bulk Model Training for a given algorithm and parameters.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
iris_hf <- as.h2o(iris)
models <- h2o.train_segments(algorithm = "gbm", 
                             segment_columns = "Species",
                             x = c(1:3), y = 4, 
                             training_frame = iris_hf,
                             ntrees = 5, 
                             max_depth = 4)
as.data.frame(models)
}
}
