% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/glrm.R
\name{h2o.reconstruct}
\alias{h2o.reconstruct}
\title{Reconstruct Training Data via H2O GLRM Model}
\usage{
h2o.reconstruct(object, data, reverse_transform = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2ODimReductionModel} object that represents the
model to be used for reconstruction.}

\item{data}{An H2OFrame object representing the training data for the H2O GLRM model.
Used to set the domain of each column in the reconstructed frame.}

\item{reverse_transform}{(Optional) A logical value indicating whether to reverse the
transformation from model-building by re-scaling columns and adding back the
offset to each column of the reconstructed frame.}
}
\value{
Returns an H2OFrame object containing the approximate reconstruction of the
        training data;
}
\description{
Reconstruct the training data and impute missing values from the H2O GLRM model
by computing the matrix product of X and Y, and transforming back to the original
feature space by minimizing each column's loss function.
}
\examples{
\donttest{
library(h2o)
h2o.init()
irisPath <- system.file("extdata", "iris_wheader.csv", package="h2o")
iris.hex <- h2o.uploadFile(path = irisPath)
iris.glrm <- h2o.glrm(training_frame = iris.hex, k = 4, transform = "STANDARDIZE",
                      loss = "Quadratic", multi_loss = "Categorical", max_iterations = 1000)
iris.rec <- h2o.reconstruct(iris.glrm, iris.hex, reverse_transform = TRUE)
head(iris.rec)
}
}
\seealso{
\code{\link{h2o.glrm}} for making an H2ODimReductionModel.
}

