% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.naiveBayes}
\alias{h2o.naiveBayes}
\title{Compute naive Bayes probabilities on an H2O dataset.}
\usage{
h2o.naiveBayes(x, y, training_frame, model_id = NULL, nfolds = 0,
  seed = -1, fold_assignment = c("AUTO", "Random", "Modulo", "Stratified"),
  fold_column = NULL, keep_cross_validation_predictions = FALSE,
  keep_cross_validation_fold_assignment = FALSE, validation_frame = NULL,
  ignore_const_cols = TRUE, score_each_iteration = FALSE,
  balance_classes = FALSE, class_sampling_factors = NULL,
  max_after_balance_size = 5, max_hit_ratio_k = 0, laplace = 0,
  threshold = 0.001, min_sdev = 0.001, eps = 0, eps_sdev = 0,
  min_prob = 0.001, eps_prob = 0, compute_metrics = TRUE,
  max_runtime_secs = 0)
}
\arguments{
\item{x}{A vector containing the names or indices of the predictor variables to use in building the model.
If x is missing,then all columns except y are used.}

\item{y}{The name of the response variable in the model.If the data does not contain a header, this is the first column
index, and increasing from left to right. (The response must be either an integer or a
categorical variable).}

\item{training_frame}{Id of the training data frame (Not required, to allow initial validation of model parameters).}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{nfolds}{Number of folds for N-fold cross-validation (0 to disable or >= 2). Defaults to 0.}

\item{seed}{Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default)
Defaults to -1 (time-based random number).}

\item{fold_assignment}{Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified' option will
stratify the folds based on the response variable, for classification problems. Must be one of: "AUTO",
"Random", "Modulo", "Stratified". Defaults to AUTO.}

\item{fold_column}{Column with cross-validation fold index assignment per observation.}

\item{keep_cross_validation_predictions}{\code{Logical}. Whether to keep the predictions of the cross-validation models. Defaults to FALSE.}

\item{keep_cross_validation_fold_assignment}{\code{Logical}. Whether to keep the cross-validation fold assignment. Defaults to FALSE.}

\item{validation_frame}{Id of the validation data frame.}

\item{ignore_const_cols}{\code{Logical}. Ignore constant columns. Defaults to TRUE.}

\item{score_each_iteration}{\code{Logical}. Whether to score during each iteration of model training. Defaults to FALSE.}

\item{balance_classes}{\code{Logical}. Balance training data class counts via over/under-sampling (for imbalanced data). Defaults to
FALSE.}

\item{class_sampling_factors}{Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will
be automatically computed to obtain class balance during training. Requires balance_classes.}

\item{max_after_balance_size}{Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires
balance_classes. Defaults to 5.0.}

\item{max_hit_ratio_k}{Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable)
Defaults to 0.}

\item{laplace}{Laplace smoothing parameter Defaults to 0.}

\item{threshold}{This argument is deprecated, use `min_sdev` instead. The minimum standard deviation to use for observations without enough data.
Must be at least 1e-10.}

\item{min_sdev}{The minimum standard deviation to use for observations without enough data.
Must be at least 1e-10.}

\item{eps}{This argument is deprecated, use `eps_sdev` instead. A threshold cutoff to deal with numeric instability, must be positive.}

\item{eps_sdev}{A threshold cutoff to deal with numeric instability, must be positive.}

\item{min_prob}{Min. probability to use for observations with not enough data.}

\item{eps_prob}{Cutoff below which probability is replaced with min_prob.}

\item{compute_metrics}{\code{Logical}. Compute metrics on training data Defaults to TRUE.}

\item{max_runtime_secs}{Maximum allowed runtime in seconds for model training. Use 0 to disable. Defaults to 0.}
}
\value{
Returns an object of class \linkS4class{H2OBinomialModel} if the response has two categorical levels,
        and \linkS4class{H2OMultinomialModel} otherwise.
}
\description{
The naive Bayes classifier assumes independence between predictor variables conditional
on the response, and a Gaussian distribution of numeric predictors with mean and standard
deviation computed from the training dataset. When building a naive Bayes classifier,
every row in the training dataset that contains at least one NA will be skipped completely.
If the test dataset has missing values, then those predictors are omitted in the probability
calculation during prediction.
}
\details{
The naive Bayes classifier assumes independence between predictor variables conditional         on the
         response, and a Gaussian distribution of numeric predictors with mean and standard         deviation
         computed from the training dataset. When building a naive Bayes classifier,         every row in the
         training dataset that contains at least one NA will be skipped completely.         If the test dataset has
         missing values, then those predictors are omitted in the probability         calculation during prediction.
}
\examples{
\donttest{
h2o.init()
votesPath <- system.file("extdata", "housevotes.csv", package="h2o")
votes.hex <- h2o.uploadFile(path = votesPath, header = TRUE)
h2o.naiveBayes(x = 2:17, y = 1, training_frame = votes.hex, laplace = 3)
}
}

