\name{screeplot.H2OPCAModel}
\alias{screeplot.H2OPCAModel}
\title{ Summarizes the columns of an H2O parsed FluidVecs data set. }
\description{
\code{screeplot.H2OPCAModel}, a method for the \code{\link{screeplot}} generic. Plots the variances against the number of the principal component generated by \code{\link{h2o.prcomp}}.
}
\usage{
\method{screeplot}{H2OPCAModel}(x, npcs = min(10, length(x@model$sdev)), type = "barplot", 
  main = paste("h2o.prcomp(", x@data@key, ")", sep=""), ...)
}
\arguments{
  \item{x}{An \code{\linkS4class{H2OPCAModel}} object.}
  \item{npcs}{Number of components to be plotted.}
  \item{type}{Type of plot, must be either \code{"barplot"} or \code{"lines"}.}
  \item{main}{Title of the plot.}
  \item{...}{Additional parameters to be passed to the plotting function.}
}

\examples{
\dontrun{
library(h2o)
localH2O = h2o.init(ip = "localhost", port = 54321, startH2O = TRUE)
ausPath = system.file("extdata", "australia.csv", package = "h2o")
australia.hex = h2o.importFile(localH2O, path = ausPath)
australia.pca = h2o.prcomp(data = australia.hex, standardize = TRUE)
screeplot(australia.pca)
}
}
