% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_variants.R
\name{get_variants_by_study_id}
\alias{get_variants_by_study_id}
\title{Get GWAS Catalog variants by study identifiers}
\usage{
get_variants_by_study_id(
  study_id = NULL,
  verbose = FALSE,
  warnings = TRUE,
  page_size = 20L
)
}
\arguments{
\item{study_id}{A character vector of GWAS Catalog study accession
identifiers.}

\item{verbose}{Whether the function should be verbose about the different
queries or not.}

\item{warnings}{Whether to print warnings.}

\item{page_size}{An integer scalar indicating the
\href{https://www.ebi.ac.uk/gwas/rest/docs/api#_paging_resources}{page}
value to be used in the JSON requests, can be between \code{1} and
\code{1000}.}
}
\value{
A \linkS4class{variants} object.
}
\description{
Gets variants by GWAS Catalog internal study identifiers.
}
\keyword{internal}
