% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefbootstrap.R
\name{coefbootstrap}
\alias{coefbootstrap}
\alias{coefbootstrap.lm}
\alias{coefbootstrap.alm}
\title{Bootstrap for parameters of models}
\usage{
coefbootstrap(object, nsim = 1000, size = floor(0.75 * nobs(object)),
  replace = FALSE, prob = NULL, parallel = FALSE)

\method{coefbootstrap}{lm}(object, nsim = 1000, size = floor(0.75 *
  nobs(object)), replace = FALSE, prob = NULL, parallel = FALSE)

\method{coefbootstrap}{alm}(object, nsim = 1000, size = floor(0.75 *
  nobs(object)), replace = FALSE, prob = NULL, parallel = FALSE)
}
\arguments{
\item{object}{The model estimated using either lm, or alm, or glm.}

\item{nsim}{Number of iterations (simulations) to run.}

\item{size}{A non-negative integer giving the number of items to choose (the sample size),
passed to \link[base]{sample} function in R. If not provided and model contains ARIMA
components, this value will be selected at random on each iteration.}

\item{replace}{Should sampling be with replacement? Also, passed to \link[base]{sample}
function in R.}

\item{prob}{A vector of probability weights for obtaining the elements of the vector
being sampled. This is passed to the \link[base]{sample} as well.}

\item{parallel}{Either a logical, specifying whether to do the calculations in parallel,
or the number, specifying the number of cores to use for the parallel calculation.}
}
\value{
Class "bootstrap" is returned, which contains:
\itemize{
\item vcov - the covariance matrix of parameters;
\item coefficients - the matrix with the bootstrapped coefficients.
\item nsim - number of runs done;
\item size - the sample size used in the bootstrap;
\item replace - whether the sampling was done with replacement;
\item prob - a vector of probability weights used in the process;
\item parallel - whether the calculations were done in parallel;
\item model - the name of the model used (the name of the function);
\item timeElapsed - the time that was spend on the calculations.
}
}
\description{
The function does the bootstrap for parameters of models and returns covariance matrix
together with the original bootstrapped data.
}
\details{
The function applies the same model as in the provided object on a smaller sample in
order to get the estimates of parameters and capture the uncertainty about them. This is
a simple implementation of the case resampling, which assumes that the observations are
independent.
}
\examples{
# An example with ALM
ourModel <- alm(mpg~., mtcars, distribution="dlnorm", loss="HAM")
# A fast example with 10 iterations. Use at least 1000 to get better results
coefbootstrap(ourModel, nsim=10)

}
\seealso{
\code{\link[greybox]{alm}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
