% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.gremlin.R
\name{summary.gremlin}
\alias{summary.gremlin}
\alias{print.summary.gremlin}
\alias{print.summary.gremlin}
\title{Gremlin model summary.}
\usage{
\method{summary}{gremlin}(object, ...)

\method{print}{summary.gremlin}(x, digits = max(3, getOption("digits") - 3),
  ...)
}
\arguments{
\item{object, x}{An object of \code{class} \sQuote{gremlin} or
\sQuote{summary.gremlin}.}

\item{\dots}{Additional arguments to be passed to control the output.}

\item{digits}{An \code{integer} used for number formatting with
\sQuote{signif()}.}
}
\value{
A \code{list} of class \code{summary.gremlin} or a printed value
  to the screen with no return values.
  \describe{
    \item{logLik }{Model log-likelihood.}
    \item{formulae }{Model fixed, random, and residual formulae.}
    \item{varcompSummary }{Table of variance components and approximate
      standard errors (calculated from the inverse of the average information
      matrix).}
    \item{fxdSummary }{Table of fixed effects and standard errors (calculated
      from the corresponding diagonal elements of the inverse of the
      coefficient matrix).}
  }
}
\description{
Summarize and print results of linear mixed model fitted with gremlin.
}
\seealso{
\code{\link{gremlin}}
}
\author{
\email{matthewwolak@gmail.com}
}
