% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_utils.R
\name{param-utils}
\alias{param-utils}
\alias{rphi2x}
\alias{x2rphi}
\alias{rtheta}
\alias{dtheta}
\title{Internal functions to map between Euclidean
and spherical coordinates}
\usage{
rphi2x(rphi)

x2rphi(x)

rtheta(n, lambda = 1, R, theta.base)

dtheta(theta, lambda, theta.base, H.elements)
}
\arguments{
\item{rphi}{numeric vector where the first element
is the radius and the remaining are the angles}

\item{x}{parameters in the Euclidean space to be converted}

\item{n}{integer to define the size of the correlation matrix}

\item{lambda}{numeric as the parameter for the
Exponential distribution of the radius}

\item{R}{scaling matrix (square root of the Hessian
around the base model)}

\item{theta.base}{numeric vector of the base model}

\item{theta}{numeric vector of length \code{m}.}

\item{H.elements}{list output of theta2H}
}
\description{
Internal functions to map between Euclidean
and spherical coordinates
}
\details{
For details, please see the wikipedia entry on 'N-sphere' at
\href{https://en.wikipedia.org/wiki/N-sphere}{N-sphere}
}
\section{Functions}{
\itemize{
\item \code{rphi2x()}: Map between spherical to Euclidean coordinates

\item \code{x2rphi()}: Transform from Euclidean coordinates to spherical

\item \code{rtheta()}: Drawn samples from the PC-prior for correlation

\item \code{dtheta()}: PC-prior density for the correlation matrix

}}
