% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphab_project.R
\name{graphab_project}
\alias{graphab_project}
\title{Create a Graphab project}
\usage{
graphab_project(
  proj_name,
  raster,
  habitat,
  minarea = 0,
  nodata = NULL,
  alloc_ram = NULL,
  proj_path = NULL
)
}
\arguments{
\item{proj_name}{A character string indicating the Graphab project name.
The project name is also the name of the project directory in which the
file proj_name.xml will be created.}

\item{raster}{A character string indicating the name of the .tif raster file
or of its path. If the path is not specified, the raster must present in the
current working directory. Raster cell values must be in INT2S encoding.}

\item{habitat}{An integer or numeric value or vector indicating the
code.s (cell value.s) of the habitat cells in the raster file.}

\item{minarea}{(optional, default=0) An integer or numeric value specifiying
the minimum area in hectares for a habitat patch size to become a graph node.}

\item{nodata}{(optional, default=NULL) An integer or numeric value
specifying the code in the raster file associated with nodata value
(often corresponding to peripheric cells)}

\item{alloc_ram}{(optional, default = NULL) Integer or numeric value
indicating RAM gigabytes allocated to the java process. Increasing this
value can speed up the computations. Too large values may not be compatible
with your machine settings.}

\item{proj_path}{(optional) A character string indicating the path to the
directory that contains the project directory. It should be used when the
project directory is not in the current working directory. Default is NULL.
When 'proj_path = NULL', the project directory is equal to \code{getwd()}.}
}
\description{
The function creates a Graphab project from a raster file on
which habitat patches can be delimited.
}
\details{
A habitat patch consists of the central pixel with its eight
neighbors if they are of the same value (8-connexity) and the path
geometry is not simplified. See more information in Graphab 2.4 manual:
\url{https://sourcesup.renater.fr/www/graphab/download/manual-2.4-en.pdf}
}
\examples{
\dontrun{
proj_name <- "grphb_ex"
raster <- "rast_ex.tif"
habitat <- 5
graphab_project(proj_name = proj_name,
               raster = raster,
               habitat = habitat)
}
}
\author{
P. Savary
}
