% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\name{splice_index}
\alias{splice_index}
\title{Splice an index series}
\usage{
splice_index(x, periods = NULL, initial = NULL, published = FALSE)
}
\arguments{
\item{x}{A list of equal-length numeric vectors giving the period-over-period
indexes for each window.}

\item{periods}{An integer vector giving the splice points for each window.
The default splices on each point in the window.}

\item{initial}{A numeric vector giving an initial period-over-period index
series onto which the elements of \code{x} are spliced. The default uses the
first element of \code{x}.}

\item{published}{Should the splice be done against the published series? The
default splices using the recalculated index series.}
}
\value{
A numeric vector giving the spliced (fixed-base) index series.
}
\description{
Splice a collection of index series computed over a rolling window into one
index series. Splicing on multiple points combines the results with a
geometric mean.
}
\examples{
# Make an index series over a rolling window
x <- list(c(1.1, 0.9, 1.2), c(0.8, 1.3, 1.4), c(1.3, 1.3, 0.8))

# Mean splice

splice_index(x)

# Movement splice

splice_index(x, 3)

# Window splice

splice_index(x, 1)

# Splicing on the published series preserves the within-window
# movement of the index series

splice_index(x, 1, published = TRUE)

}
\references{
Chessa, A. G. (2019).
\emph{A Comparison of Index Extension Methods for Multilateral Methods.} Paper
presented at the 16th Meeting of the Ottawa Group on Price Indices,
8-10 May 2019, Rio de Janeiro, Brazil.

Krsinich, F. (2016). The FEWS index: Fixed effects with a window splice.
\emph{Journal of Official Statistics}, 32(2), 375-404.
}
\seealso{
Other price index functions: 
\code{\link{geks}()},
\code{\link{index_weights}()},
\code{\link{price_indexes}}
}
\concept{price index functions}
