% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{usamone}
\alias{usamone}
\title{A quarterly U.S. data covering the period from 1954Q3 to 2021Q1 (267 observations) and consisting four variables:
cyclical component of the log of real GDP, the log-difference of GDP implicit price deflator, the log-diffence of producer
price index (all commodities), and an interest rate variable. The interest rate variable is the effective federal funds (FF)
rate from 1954Q3 to 2008Q2 and after that the Wu and Xia (2016) shadow rate, which is not constrained by the zero lower
bound and also quantifies unconventional monetary policy measures. This data is the one that was used in Virolainen (2021).}
\format{
A numeric matrix of class \code{'ts'} with 267 rows and 4 columns with one time series in each column:
\describe{
  \item{First column (GDP):}{The cyclical component of the log of real GDP, \url{https://fred.stlouisfed.org/series/GDPC1}.}
  \item{Second column (GDPDEF):}{The log-difference of GDP implicit price deflator, \url{https://fred.stlouisfed.org/series/GDPDEF}.}
  \item{Third column (PPI):}{The log-difference of producer price index (all commodities), \url{https://fred.stlouisfed.org/series/PPIACO}.}
  \item{Third column (RATE):}{The Federal funds rate from 1954Q3 to 2008Q2 and after that the Wu and Xia (2016) shadow rate,
   \url{https://fred.stlouisfed.org/series/FEDFUNDS}, \url{https://www.atlantafed.org/cqer/research/wu-xia-shadow-federal-funds-rate}.}
}
}
\source{
The Federal Reserve Bank of St. Louis database and the Federal Reserve Bank of Atlanta's website
}
\usage{
usamone
}
\description{
The cyclical component of the log of real GDP was obtained by applying a one-sided Hodrick-Prescott (HP) filter with the
standard smoothing parameter lambda=1600. The one-sided filter was obtained from the two-sided HP filter by applying the
filter up to horizon t, taking the last observation, and repeating this procedure for the full sample t=1,...,T.
In order to allow the series to start from any phase of the cycle, we applied the one-sided filter to the full available
sample from 1947Q1 to 2021Q1 before extracting our sample period from it. We computed the two-sided HP filters with the R
package lpirfs (Adämmer, 2021)
}
\references{
\itemize{
   \item Adämmer P. 2021. lprfs: Local Projections Impulse Response Functions. R package version: 0.2.0,
     \url{https://CRAN.R-project.org/package=lpirfs}.
   \item Virolainen S. 2021. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
   \item Wu J. and Xia F. 2016. Measuring the macroeconomic impact of monetary policy at the zero lower bound.
     \emph{Journal of Money, Credit and Banking}, 48(2-3): 253-291.
 }
}
\keyword{datasets}
