% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMVARconstruction.R
\name{alt_gsmvar}
\alias{alt_gsmvar}
\title{Construct a GMVAR, StMVAR, or G-StMVAR model based on results from an arbitrary estimation round of \code{fitGSMVAR}}
\usage{
alt_gsmvar(
  gsmvar,
  which_round = 1,
  which_largest,
  calc_cond_moments = TRUE,
  calc_std_errors = TRUE
)
}
\arguments{
\item{gsmvar}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{which_round}{based on which estimation round should the model be constructed? An integer value in 1,...,\code{ncalls}.}

\item{which_largest}{based on estimation round with which largest log-likelihood should the model be constructed?
An integer value in 1,...,\code{ncalls}. For example, \code{which_largest=2} would take the second largest log-likelihood
and construct the model based on the corresponding estimates. If used, then \code{which_round} is ignored.}

\item{calc_cond_moments}{should conditional means and covariance matrices should be calculated?
Default is \code{TRUE} if the model contains data and \code{FALSE} otherwise.}

\item{calc_std_errors}{should approximate standard errors be calculated?}
}
\value{
Returns an object of class \code{'gsmvar'} defining the specified reduced form or structural GMVAR,
  StMVAR, or G-StMVAR model. Can be used to work with other functions provided in \code{gmvarkit}.

  Note that the first autocovariance/correlation matrix in \code{$uncond_moments} is for the lag zero,
  the second one for the lag one, etc.
}
\description{
\code{alt_gsmvar} constructs a GMVAR, StMVAR, or G-StMVAR model based on results from
  an arbitrary estimation round of \code{fitGSMVAR}.
}
\details{
It's sometimes useful to examine other estimates than the one with the highest log-likelihood. This function
  is wrapper around \code{GSMVAR} that picks the correct estimates from an object returned by \code{fitGSMVAR}.
}
\examples{
\donttest{
# GMVAR(1,2) model
fit12 <- fitGSMVAR(gdpdef, p=1, M=2, ncalls=2, seeds=4:5)
fit12
fit12_2 <- alt_gsmvar(fit12, which_largest=2)
fit12_2
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Kalliovirta L. and Saikkonen P. 2010. Reliable Residuals for Multivariate Nonlinear
         Time Series Models. \emph{Unpublished Revision of HECER Discussion Paper No. 247}.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
   \item Virolainen S. 2021. Gaussian and Student's t mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2109.13648.
 }
}
\seealso{
\code{\link{fitGSMVAR}}, \code{\link{GSMVAR}}, \code{\link{iterate_more}}, \code{\link{update_numtols}}
}
