% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue.R
\name{glue}
\alias{glue}
\alias{glue_data}
\alias{glue}
\title{Format and interpolate a string}
\usage{
glue_data(.x, ..., .sep = "", .envir = parent.frame(), .open = "{",
  .close = "}", .na = "NA", .transformer = identity_transformer,
  .trim = TRUE)

glue(..., .sep = "", .envir = parent.frame(), .open = "{", .close = "}",
  .na = "NA", .transformer = identity_transformer)
}
\arguments{
\item{.x}{[\code{listish}]\cr An environment, list or data frame used to lookup values.}

\item{...}{[\code{expressions}]\cr Expressions string(s) to format, multiple inputs are concatenated together before formatting.}

\item{.sep}{[\code{character(1)}: \sQuote{""}]\cr Separator used to separate elements.}

\item{.envir}{[\code{environment}: \code{parent.frame()}]\cr Environment to evaluate each expression in. Expressions are
evaluated from left to right. If \code{.x} is an environment, the expressions are
evaluated in that environment and \code{.envir} is ignored.}

\item{.open}{[\code{character(1)}: \sQuote{\{}]\cr The opening delimiter. Doubling the
full delimiter escapes it.}

\item{.close}{[\code{character(1)}: \sQuote{\}}]\cr The closing delimiter. Doubling the
full delimiter escapes it.}

\item{.na}{[\code{character(1)}: \sQuote{NA}]\cr Value to replace NA values
with. If \code{NULL} missing values are propagated, that is an \code{NA} result will
cause \code{NA} output. Otherwise the value is replaced by the value of \code{.na}.}

\item{.transformer}{[\code{function]}\cr A function taking three parameters \code{code}, \code{envir} and
\code{data} used to transform the output of each block before during or after
evaluation. For example transformers see \code{vignette("transformers")}.}

\item{.trim}{[\code{logical(1)}: \sQuote{TRUE}]\cr Whether to trim the input
template with \code{trim()} or not.}
}
\description{
Expressions enclosed by braces will be evaluated as R code. Long strings are
broken by line and concatenated together. Leading whitespace and blank lines
from the first and last lines are automatically trimmed.
}
\examples{
name <- "Fred"
age <- 50
anniversary <- as.Date("1991-10-12")
glue('My name is {name},',
  'my age next year is {age + 1},',
  'my anniversary is {format(anniversary, "\%A, \%B \%d, \%Y")}.')

# single braces can be inserted by doubling them
glue("My name is {name}, not {{name}}.")

# Named arguments can be used to assign temporary variables.
glue('My name is {name},',
  ' my age next year is {age + 1},',
  ' my anniversary is {format(anniversary, "\%A, \%B \%d, \%Y")}.',
  name = "Joe",
  age = 40,
  anniversary = as.Date("2001-10-12"))


# `glue_data()` is useful in magrittr pipes
library(magrittr)
mtcars \%>\% glue_data("{rownames(.)} has {hp} hp")

# Or within dplyr pipelines
library(dplyr)
head(iris) \%>\%
  mutate(description = glue("This {Species} has a petal length of {Petal.Length}"))

# Alternative delimiters can also be used if needed
one <- "1"
glue("The value of $e^{2\\\\pi i}$ is $<<one>>$.", .open = "<<", .close = ">>")
}
\seealso{
\url{https://www.python.org/dev/peps/pep-0498/} and
\url{https://www.python.org/dev/peps/pep-0257} upon which this is based.
}
