% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{fixef}
\alias{fixef}
\alias{fixef.glmmTMB}
\title{Extract fixed-effects estimates}
\usage{
\method{fixef}{glmmTMB}(object, ...)
}
\arguments{
\item{object}{any fitted model object from which fixed effects estimates can
be extracted.}

\item{\dots}{optional additional arguments. Currently none are used in any
methods.}
}
\value{
a named, numeric vector of fixed-effects estimates.
}
\description{
Extract the fixed-effects estimates
}
\details{
Extract the estimates of the fixed-effects parameters from a fitted model.
}
\examples{
data(sleepstudy, package = "lme4")
fixef(glmmTMB(Reaction ~ Days + (1|Subject) + (0+Days|Subject), sleepstudy))
}
\keyword{models}

