% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcn.R
\name{cv_glmaag}
\alias{cv_glmaag}
\title{Cross validation for glmaag}
\usage{
cv_glmaag(y, x, L, nfolds = 5, cvwhich, foldseed, stratify = T,
  gam = 1, tune = F, est = T, lam1, lam2, dfmax, w0, adaptl1 = T,
  adaptl2 = T, pind, intercept = T, standardize = T,
  maxiter = 10000, cri = 0.001, fam = "Gaussian", measdev = T,
  type1se = T, parallel = F)
}
\arguments{
\item{y}{outcome}

\item{x}{predictors matrix}

\item{L}{Laplacian matrix for the first network}

\item{nfolds}{number of folds used in cross validation, default to be five}

\item{cvwhich}{fold assignment, start from zero, if missing do random cross validation}

\item{foldseed}{the random seed for cross validation design}

\item{stratify}{whether to do stratified cross validation for Logistic or Cox model, default to be TRUE}

\item{gam}{The power of weights of L1 penalty, default to be ones}

\item{tune}{whether to tune the input network with estimated network or identity matrix, ignored if no input network}

\item{est}{when there is no input network whether to use estimated network or identiy matrix (elastic net) or mixed the network with estimated network or identity matrix, default to be estimated network}

\item{lam1}{The tuning parameters for L1 penalty. If not defined, searched by default}

\item{lam2}{The tuning parameters for quadratic penalty. If not defined, searched by default}

\item{dfmax}{maximum number of parameters allowed in the model, default to be p/2}

\item{w0}{Weights for L1 penalty. If not defined, estimated via quadratic penalyzed regression}

\item{adaptl1}{whether to adapt the L1 penalty, default to be TRUE}

\item{adaptl2}{whether to adapt the sign for quadratic penalty, default to be TRUE}

\item{pind}{indicator vector whether to put L1 penalty on the feature, 1 means penalyzed while 0 means not penalyzed, default to be all ones (all penalyzed)}

\item{intercept}{whether to include intercept. Ignore for Cox regression}

\item{standardize}{whether to standardize predictors}

\item{maxiter}{maximum number of iterations, default to be 500}

\item{cri}{stoppint criterion, default to be 0.001}

\item{fam}{family for the outcome, can be "Gaussian", "Logistic", and "Cox"}

\item{measdev}{Whether to use deviance to tune, default to be deviance. If not, use mean absolue error, area under ROC curve, or concordance index for Gaussian, Logistic, and Cox}

\item{type1se}{whether to use one standard error or maximum rule, default to be one standard error rule}

\item{parallel}{whether to do parallel computing at each fold, need to set up parallel first, default to be FALSE}
}
\value{
\item{input}{input predictor matrix}

\item{inputweight}{estimated weights if mixing network}

\item{lambda1}{lambda1 path that has been searched}

\item{lambda1}{lambda1 path that has been searched}

\item{lambda1_max}{selected lambda1 based on maximum rule}

\item{lambda2_max}{selected lambda2 based on maximum rule}

\item{lambda1_1se}{selected lambda1 based on one standard error rule}

\item{lambda2_1se}{selected lambda2 based on one standard error rule}

\item{cvm}{the mean cross validation accuracy}

\item{cv1se}{the standard error of cross validation accuracy}

\item{cvn}{the mean number of parameter estimated among folds}

\item{n_max}{number of selected features based on maximum rule}

\item{n_1se}{number of selected features based on one standard error rule}

\item{intercept_max}{estimated intercept based on maximum rule}

\item{intercept_1se}{estimated intercept based on one standard error rule}

\item{coef_max}{estimated coefficients based on maximum rule}

\item{coef_1se}{estimated coefficients based on one standard error rule}

\item{fam}{family of outcome}

\item{measure}{measure in cross validation}
}
\description{
Do k-fold cross-validation for glmaag
}
\examples{
data(sampledata)
data(L0)
y <- sampledata$Y_Gau
x <- sampledata[, -(1:3)]
cvwhich <- sample(rep(0:4, length.out = length(y)))
mod <- cv_glmaag(y, x, L0, cvwhich = cvwhich)
}
