% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_git_log.R
\name{tar_git_log}
\alias{tar_git_log}
\title{Data snapshots of a code branch (Git)}
\usage{
tar_git_log(
  code = getwd(),
  store = targets::tar_config_get("store"),
  branch = gert::git_branch(repo = code),
  max = 100
)
}
\arguments{
\item{code}{Character of length 1, directory path to the code repository,
usually the root of the \code{targets} project.}

\item{store}{Character of length 1, path to the data store of the pipeline.
If \code{NULL}, the \code{store} setting is left unchanged in the
YAML configuration file (default: \verb{_targets.yaml}).
Usually, the data store lives at \verb{_targets}.
Set \code{store} to a custom directory
to specify a path other than \verb{_targets/}. The path need not exist
before the pipeline begins, and it need not end with "_targets",
but it must be writeable.
For optimal performance, choose a storage location
with fast read/write access.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[targets:tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{branch}{Character of length 1, name of the code repository branch
to query. Defaults to the currently checked-out code branch.}

\item{max}{Positive numeric of length 1, maximum number of code commits
to inspect for the given branch.}
}
\value{
A data frame of information about
data snapshots and code commits.
}
\description{
Show all the data snapshots of a code branch.
}
\details{
By design, \code{tar_git_log()} only queries a single
code branch at a time. This allows \code{tar_git_log()}
to report more detailed information about the snapshots
of the given code branch.
To query all data snapshots over all branches, simply run
\code{gert::git_branch_list(local = TRUE, repo = "_targets")}.
The valid snapshots show \code{"code=<SHA1>"} in the \code{name} column,
where \verb{<SHA1>} is the Git commit hash of the code commit
corresponding to the data snapshot.
}
\examples{
if (Sys.getenv("TAR_EXAMPLES") == "true" && tar_git_ok(verbose = FALSE)) {
targets::tar_dir({ # Containing code does not modify the user's filespace.
targets::tar_script(tar_target(data, 1))
targets::tar_make()
gert::git_init()
gert::git_add("_targets.R")
gert::git_commit("First commit")
tar_git_init()
tar_git_snapshot(status = FALSE, verbose = FALSE)
tar_git_log()
})
}
}
\seealso{
Other git: 
\code{\link{tar_git_checkout}()},
\code{\link{tar_git_init}()},
\code{\link{tar_git_ok}()},
\code{\link{tar_git_snapshot}()},
\code{\link{tar_git_status_code}()},
\code{\link{tar_git_status_data}()},
\code{\link{tar_git_status_targets}()},
\code{\link{tar_git_status}()}
}
\concept{git}
