% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-data.R
\docType{data}
\name{data_Feldspar}
\alias{data_Feldspar}
\alias{Feldspar}
\alias{FeldsparRaster}
\title{Elkin and Groves Feldspar Data}
\format{\code{Feldsdpar} - One (1) row per Feldspar composition, \code{FeldsdparRaster} - Raster Matrix}
\usage{
#Experimental Data
data(Feldspar)

#Raster data
data(FeldsparRaster)
}
\description{
Data relating to Elkins and Groves Feldspar Data, the following datasets include 
the experimental data and sample raster data from one of the images in the 
referenced paper.
\code{Feldspar} - Experimental Data
\code{FeldsparRaster} - Raster Data for Fig. 6.
}
\examples{
#Summarize the Feldspar Data
data(Feldspar)
summary(Feldspar)

#Plot Felspar Data
ggtern(data=Feldspar,aes(x=An,y=Ab,z=Or)) + 
    geom_point()

# Plot Feldspar data and Underlying Raster Image
data(FeldsparRaster)
ggtern(Feldspar,aes(Ab,An,Or)) + 
    theme_rgbw() + 
    annotation_raster_tern(FeldsparRaster,xmin=0,xmax=1,ymin=0,ymax=1) +
    geom_point(size=5,aes(shape=Feldspar,fill=Feldspar),color='black') +
    scale_shape_manual(values=c(21,24)) +
    labs(title = "Demonstration of Raster Annotation")
    
}
\references{
Elkins, L. T. & Grove, T. L. 
Ternary Feldspar Experiments and Thermodynamic Models 
American Mineralogist, Mineral Soc America, 1990, 75, 544-559
}
\seealso{
\link[=data]{Data}
}
\author{
Nicholas Hamilton
}
