% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_plots.R
\name{combine_plots}
\alias{combine_plots}
\title{Combining and arranging multiple plots in a grid}
\usage{
combine_plots(
  plotlist,
  plotgrid.args = list(),
  annotation.args = list(),
  guides = "collect",
  ...
)
}
\arguments{
\item{plotlist}{A list containing \code{ggplot} objects.}

\item{plotgrid.args}{A \code{list} of additional arguments passed to
\code{patchwork::wrap_plots()}, except for \code{guides} argument which is already
separately specified here.}

\item{annotation.args}{A \code{list} of additional arguments passed to
\code{patchwork::plot_annotation()}.}

\item{guides}{A string specifying how guides should be treated in the layout.
\code{'collect'} will collect guides below to the given nesting level, removing
duplicates. \code{'keep'} will stop collection at this level and let guides be
placed alongside their plot. \code{auto} will allow guides to be collected if a
upper level tries, but place them alongside the plot if not.  If you modify
default guide "position" with \link[ggplot2:theme]{theme(legend.position=...)}
while also collecting guides you must apply that change to the overall
patchwork (see example).}

\item{...}{Currently ignored.}
}
\value{
A combined plot with annotation labels.
}
\description{
Wrapper around \code{patchwork::wrap_plots()} that will return a combined grid of
plots with annotations. In case you want to create a grid of plots, it is
\strong{highly recommended} that you use \code{{patchwork}} package directly and not
this wrapper around it which is mostly useful with \code{{ggstatsplot}} plots. It
is exported only for backward compatibility.
}
\examples{
library(ggplot2)

# first plot
p1 <- ggplot(
  data = subset(iris, iris$Species == "setosa"),
  aes(x = Sepal.Length, y = Sepal.Width)
) +
  geom_point() +
  labs(title = "setosa")

# second plot
p2 <- ggplot(
  data = subset(iris, iris$Species == "versicolor"),
  aes(x = Sepal.Length, y = Sepal.Width)
) +
  geom_point() +
  labs(title = "versicolor")

# combining the plot with a title and a caption
combine_plots(
  plotlist = list(p1, p2),
  plotgrid.args = list(nrow = 1),
  annotation.args = list(
    tag_levels = "a",
    title = "Dataset: Iris Flower dataset",
    subtitle = "Edgar Anderson collected this data",
    caption = "Note: Only two species of flower are displayed",
    theme = theme(
      plot.subtitle = element_text(size = 20),
      plot.title = element_text(size = 30)
    )
  )
)
}
