% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_points.R
\name{draw_points}
\alias{draw_points}
\title{Draw Points on a ggplot Object}
\usage{
draw_points(p, points_data, zoom_level = 1)
}
\arguments{
\item{p}{A ggplot object to which the points will be added.}

\item{points_data}{A data frame containing information about the points to be drawn. The expected columns include:
\itemize{
  \item \code{x}, \code{y}: Coordinates of the point.
  \item \code{shape}: Shape of the point (\code{"circle"}, \code{"square"}, \code{"triangle"}, \code{"rectangle"}, \code{"oval"}, or \code{"diamond"}).
  \item \code{color}: Fill color of the point (hexadecimal color code).
  \item \code{size}: Size of the point.
  \item \code{border_color}: Border color of the point (hexadecimal color code).
  \item \code{border_width}: Width of the border.
  \item \code{alpha}: Transparency of the point (numeric, 0 to 1).
  \item \code{width_height_ratio}: Ratio of width to height (for shapes like rectangles and ovals).
  \item \code{orientation}: Rotation angle of the point in degrees (for shapes like rectangles and diamonds).
}}

\item{zoom_level}{Numeric. Adjusts the size of the points relative to the plot. Default is \code{1}.}
}
\value{
A ggplot object with the specified points added.
}
\description{
This function overlays points to a ggplot object using data from a CSV file generated by the ggsem Shiny app or any custom dataset.
Points can be styled with various shapes, colors, sizes, and orientations.
}
\examples{
library(ggplot2)

points_data <- data.frame(
x = 20, y = 20, shape = 'rectangle', color = '#D0C5ED', size = 50,
border_color = '#9646D4', border_width = 2, alpha = 1, width_height_ratio = 1.6, orientation = 45,
lavaan = FALSE, lavaan = FALSE, network = FALSE, locked = FALSE
)

p <- ggplot()

draw_points(p, points_data, zoom_level = 1.2) +
scale_x_continuous(limits = c(0,50)) +
scale_y_continuous(limits = c(0,50))

}
