% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_seed.R
\name{geom_seed}
\alias{geom_seed}
\title{geom_seed}
\usage{
geom_seed(seed, star = FALSE)
}
\arguments{
\item{seed}{character, like 'GAGGUAG' a miRNA seed sequence}

\item{star}{a logical value indicating whether symbol of stars should be produced}
}
\value{
a ggplot layer
}
\description{
Highlighting the seed in miRNA sequences
}
\examples{
miRNA_sequences <- system.file("extdata/seedSample.fa", package="ggmsa")
ggmsa(miRNA_sequences, font = 'DroidSansMono', color = "Chemistry_NT", none_bg = TRUE) + 
geom_seed(seed = "GAGGUAG") 
ggmsa(miRNA_sequences, font = 'DroidSansMono', color = "Chemistry_NT") + 
geom_seed(seed = "GAGGUAG", star = TRUE)
}
\author{
Lang Zhou
}
