## ----set-options, echo = FALSE-------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>", dev = "png", fig.width = 7, fig.height = 5, message = FALSE, warning = FALSE)

## ------------------------------------------------------------------------
library(ggeffects)
library(sjmisc)
library(lme4)
library(splines)

set.seed(123)

dat <- data.frame(
  outcome = rbinom(n = 100, size = 1, prob = 0.35),
  var_binom = as.factor(rbinom(n = 100, size = 1, prob = 0.2)),
  var_cont = rnorm(n = 100, mean = 10, sd = 7),
  group = sample(letters[1:4], size = 100, replace = TRUE)
)

dat$var_cont <- sjmisc::std(dat$var_cont)

## ------------------------------------------------------------------------
m1 <- glmer(
  outcome ~ var_binom + var_cont + (1 | group), 
  data = dat, 
  family = binomial(link = "logit")
)

## ----message = TRUE------------------------------------------------------
ggpredict(m1, "var_binom")

ggpredict(m1, "var_cont")

## ----message = FALSE-----------------------------------------------------
# save marginal effects in an object and plot
me <- ggpredict(m1, "var_binom")
plot(me)
# plot using the pipe
ggpredict(m1, "var_cont") %>% plot()

## ------------------------------------------------------------------------
m2 <- glmer(
  outcome ~ var_binom * var_cont + (1 | group), 
  data = dat, 
  family = binomial(link = "logit")
)

## ----message = TRUE------------------------------------------------------
ggpredict(m2, c("var_cont", "var_binom")) %>% plot()
ggpredict(m2, c("var_binom", "var_cont")) %>% plot()

## ------------------------------------------------------------------------
m3 <- glmer(
  outcome ~ var_binom * poly(var_cont, degree = 2, raw = TRUE) + (1 | group), 
  data = dat, 
  family = binomial(link = "logit")
)

## ----message = TRUE------------------------------------------------------
ggpredict(m3, c("var_cont", "var_binom")) %>% plot()

## ----message = TRUE------------------------------------------------------
ggpredict(m3, c("var_cont [all]", "var_binom")) %>% plot()

## ----message = FALSE-----------------------------------------------------
set.seed(321)
dat <- data.frame(
  outcome = rbinom(n = 100, size = 1, prob = 0.35),
  var_binom = rbinom(n = 100, size = 1, prob = 0.5),
  var_cont = rnorm(n = 100, mean = 10, sd = 7),
  var_cont2 = rnorm(n = 100, mean = 5, sd = 2),
  group = sample(letters[1:4], size = 100, replace = TRUE)
)


m4 <- glmer(
  outcome ~ var_binom * poly(var_cont, degree = 2) * ns(var_cont2, df = 3) + (1 | group),
  data = dat, 
  family = binomial(link = "logit")
)

## ----message = TRUE------------------------------------------------------
ggpredict(m4, c("var_cont [all]", "var_cont2", "var_binom")) %>% plot()

