% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nph_traj.R
\name{nph_traj}
\alias{nph_traj}
\title{Calculate analytic time-to-event trial properties under non-proportional hazards or other complex assumptions}
\usage{
nph_traj(active_ecurve, control_ecurve, active_dcurve = Blank(),
  control_dcurve = Blank(), rcurve, max_assessment = 100,
  landmark = NULL, RMST = NULL, alpha1 = 0.025,
  required_power = NULL, detailed_output = FALSE)
}
\arguments{
\item{active_ecurve}{Event distribution for the active arm, specified as a Curve object}

\item{control_ecurve}{Event distribution for the control arm, specified as a Curve object}

\item{active_dcurve}{Dropout/censoring distribution for the active arm, specified as a Curve object. By default, a Blank() object, i.e. no dropout.}

\item{control_dcurve}{Dropout/censoring distribution for the control arm, specified as a Curve object. By default, a Blank() object, i.e. no dropout.}

\item{rcurve}{Recruitment distribution, specified as an RCurve object}

\item{max_assessment}{Maximum assessment time to calculate properties up to}

\item{landmark}{(Optional) Time in months of landmark analysis, if required. Otherwise NULL (Not calculated; default).}

\item{RMST}{(Optional) Restriction time for RMST analysis in months, if required. Otherwise NULL (Not calculated; default).}

\item{alpha1}{One-sided alpha required, as a decimal. 0.025 by default. Requires 0 < alpha1 <= 0.5.}

\item{required_power}{(Optional) Power required for estimated sample sizes. Otherwise NULL (not calculated; default).}

\item{detailed_output}{Boolean to require a more detailed output table, including Peto LogHR, expectations of various quantities and alternative power calculations. Default = FALSE (detailed outputs omitted).}
}
\value{
Returns a table with one row per assessment time. Table contains both all input parameters as well as the following expected quantities:
\itemize{
 \item{"Time"}{ Time at which the assessment is made}
 \item{"Patients"}{ Number of patients expected to be recruited to date}
 \item{"Events_Active"}{ Expected number of observed events in active arm}
 \item{"Events_Control"}{ Expected number of observed events in control arm}
 \item{"Events_Total"}{ Expected number of events across both arms}
 \item{"HR"}{ Expected Hazard Ratio (using the Pike method)}
 \item{"LogHR"}{ Log of the expected Hazard Ratio}
 \item{"LogHR_SE"}{ SE of the log of the expected Hazard Ratio}
 \item{"Schoenfeld_Power"}{ Estimated power based on Schoenfeld formula}
 \item{"Frontier_Power"}{ Estimated power based on Frontier method, using estimated event ratio at 0.5 power}
}
In addition, if the detailed_output argument is set to TRUE, the following additional columns are provided:
\itemize{
 \item{"E_Events_Active"}{ Expected number of expected events in active arm}
 \item{"E_Events_Control"}{ Expected number of expected events in control arm}
 \item{"HR_CI_Upper"}{ Estimated Upper Bound of the CI for the Hazard Ratio}
 \item{"HR_CI_Lower"}{ Estimated Lower Bound of the CI for the Hazard Ratio}
 \item{"Peto_LogHR"}{ Expected Log Hazard Ratio using the Peto method}
 \item{"Expected_Z"}{ Estimated Z-score based on expected quantities for O, E and V, and log-rank test formula}
 \item{"Expected_P"}{ Estimated p-value based on estimated Z-score}
 \item{"Log_Rank_Stat"}{ Expected log-rank statistic}
 \item{"Variance"}{ Expected variance of LR-statistic by integration of V_function}
 \item{"V_Pike_Peto"}{ Expected variance based upon Pike and Peto approximations}
 \item{"Event_Ratio"}{ Expected ratio of events between arms; active divided by control}
 \item{"Event_Prop_Power"}{ Estimated power based on event proportion method, using event ratio rather than randomisation ratio}
 \item{"Z_Power"}{ Estimated power based on expected value of Z}
}
If RMST calculations are requested, the following columns are included:
\itemize{
 \item{"RMST_Restrict"}{ Specified RMST restriction time}
 \item{"RMST_Active"}{ Expected RMST for active arm}
 \item{"RMST_Control"}{ Expected RMST for control arm}
 \item{"RMST_Delta"}{ Absolute difference in expected RMSTs between arms (active minus control)}
 \item{"RMST_SE"}{ Estimated SE of the RMST delta}
 \item{"RMST_Z"}{ Estimated RMST Z score}
 \item{"RMST_Failure"}{ Estimated probability of RMST difference being uncomputable for the specified restriction time}
 \item{"RMST_Power"}{ Estimated RMST Power}
}
If landmark calculations are requested, the following columns are included:
\itemize{
 \item{"LM_Time"}{ Time of landmark analysis}
 \item{"LM_Active"}{ Expected Kaplan Meier estimate of active arm at landmark time }
 \item{"LM_Control"}{ Expected Kaplan Meier estimate of control arm at landmark time }
 \item{"LM_Delta"}{ Expected absolute difference in Kaplan Meiers estimates at landmark time (active-control) }
 \item{"LM_A_SE"}{ Estimated Greenwood SE for active arm at landmark time }
 \item{"LM_C_SE"}{ Estimated Greenwood SE for control arm at landmark time }
 \item{"LM_D_SE"}{ Estimated Greenwood SE for delta at landmark time }
 \item{"LM_Z"}{ Estimated landmark analysis Z-score based on Greenwood SE }
 \item{"LM_Power"}{ Estimated landmark analysis power based on Greenwood SE }
}
If a required power is requested, the following column is included:
\itemize{
 \item{"Estimated_SS"}{ Estimated sample size required, keeping constant all parameters other than rate of recruitment and total sample size}
}
}
\description{
This function calculates the expected parameters/outputs/properties for a 2-arm Time-To-Event trial under complex assumptions.\cr
It is designed to work with non-proportional hazards and ought to be able to accommodate any distributional assumptions for
events, censoring and recruitment, so long as they are correctly detailed in Curve or RCurve objects.\cr
It performs power calculation and hence sample size planning. However, identifying the optimum assessment time is also key.\cr
It uses numerical integration across event, censoring and recruitment functions to calculate expected observed and expected expected event numbers.\cr
From these, it estimates an expected HR using the Pike method, with the same interpretation as that found using Cox regression.\cr
The expected event numbers and HR can then be used in calculating power by one of several methods, including the Schoenfeld and Frontier methods.\cr
A separate, direct, power calculation can also be performed using the log-rank test formula and its Z-distribution.\cr
To assist sample size finding, it will also estimate the required sample size to reach a given power keeping all variables other than recruitment.\cr
}
\examples{
nph_traj(max_assessment=100,rcurve=LinearR(12,100,100),control_ecurve=Weibull(100,1),
active_ecurve=Weibull(250,0.8))
}
\references{
Bell J, Accurate Sample Size Calculations in Trials with Non-Proportional Hazards, 2018, presentation at PSI Conference.
\url{https://www.psiweb.org/docs/default-source/default-document-library/james-bell-slides.pdf?sfvrsn=3324dedb_0}
Bell J, Power Calculations for Time-to-Event Trials Using Predicted Event Proportions, 2019, paper under review.
Ruehl J, Sample Size Calculation in Time-To-Event Trials with Non-Proportional Hazards Using GESTATE, 2018, BSc thesis at University of Ulm.
Pike MC, Contribution to discussion in Asymptotically efficient rank invariant test procedures by Peto R and Peto J,
Journal of the Royal Statistical Society Series A, 135(2), 201-203.
}
\author{
James Bell
}
