% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_constructors.R
\name{Lognormal}
\alias{Lognormal}
\title{Log-normal Curve constructor function}
\usage{
Lognormal(mu, sigma = 1)
}
\arguments{
\item{mu}{Mean (on log scale) parameter for Log-normal distribution.}

\item{sigma}{Standard deviation (on log scale) parameter for Log-normal distribution.}
}
\description{
This creates a Curve object for a Log-normal distribution.\cr
Curve objects contain all necessary information to describe a distribution, including functions and parameters describing it.\cr
Parameterisation follows that used by plnorm etc. See Details for more information on parameterisation.
}
\details{
The log normal distribution has parameterisation:\cr
f(x) = 1/(sqrt(2*pi) sigma  x) e^-((log x - mu)^2 / (2 sigma^2))\cr
F(x) = 0.5(1 + erf((log(x)-mu)/(sigma sqrt(2))))\cr
where erf is the error function.
}
\examples{
Lognormal(mu=5,sigma=1.2)
Lognormal(6)
}
\author{
James Bell
}
