% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOStandardOrderProcess.R
\docType{class}
\name{ISOStandardOrderProcess}
\alias{ISOStandardOrderProcess}
\title{ISOStandardOrderProcess}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO StandardOrderProcess
}
\description{
ISOStandardOrderProcess
}
\section{Fields}{

\describe{
\item{\code{fees}}{[\code{\link{character}}]}

\item{\code{plannedAvailableDateTime}}{[\code{\link{POSIXt}}] the datetime}

\item{\code{orderingInstructions}}{[\code{\link{character}}] ordering instructions}

\item{\code{turnaround}}{[\code{\link{character}}] turnaround}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOStandardOrderProcess}}
 }
 \item{\code{setFees(fees, locales)}}{
   Sets fees, object of class \code{character}. Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
 \item{\code{setPlannedAvailableDateTime(dateTime)}}{
   Sets planned available datetime, object of class \code{c('POSIXct','POSIXlt')}
 }
 \item{\code{setOrderingInstructions(instructions, locales)}}{
   Sets ordering instructions, object of class \code{character}. Locale names 
   can be specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{setTurnaround(turnaround, locales)}}{
   Sets turnaround, object of class \code{character}. Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
}
}

\examples{
  md <- ISOStandardOrderProcess$new()
  md$setFees("fees")
  md$setPlannedAvailableDateTime(ISOdate(2017,7,5,12,0,0))
  md$setOrderingInstructions("instructions")
  md$setTurnaround("turnaround")
  xml <- md$encode()

}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{StandardOrderProcess}
