% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISORangeDimension.R
\docType{class}
\name{ISORangeDimension}
\alias{ISORangeDimension}
\title{ISORangeDimension}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISORangeDimension
}
\description{
ISORangeDimension
}
\section{Fields}{

\describe{
\item{\code{sequenceIdentifier}}{[\code{\link{ISOMemberName}}] sequence identifier}

\item{\code{descriptor}}{[\code{\link{character}}] description}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISORangeDimension
 }
 \item{\code{setSequenceIdentifier(memberName)}}{
   Sets the sequence identifier, object of class \code{ISOMemberName}
 }
 \item{\code{setDescriptor(descriptor ,locales)}}{
   Sets the descriptor, object of class \code{character}. Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
}
}

\examples{
   #create dimension
   md <- ISORangeDimension$new()
   md$setSequenceIdentifier(ISOMemberName$new(aName = "name", attributeType = "type"))
   md$setDescriptor("descriptor")
   xml <- md$encode()
   
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{dimension}
\keyword{range}
