% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryPlan.R
\docType{class}
\name{ISOImageryPlan}
\alias{ISOImageryPlan}
\title{ISOImageryPlan}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery Plan
}
\description{
ISOImageryPlan
}
\section{Fields}{

\describe{
\item{\code{type}}{[\code{\link{ISOImageryGeometryType}}]}

\item{\code{citation}}{[\code{\link{ISOCitation}}]}

\item{\code{operation}}{[\code{list} of \code{\link{ISOImageryOperation}}]}

\item{\code{satisfiedPlan}}{[\code{list} of \code{\link{ISOImageryPlan}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryPlan}}
 }
 \item{\code{setType(type)}}{
   Set the imagery geometry type, object of class \code{\link{ISOImageryGeometryType}}
   or 'character' among values given by \code{ISOImageryGeometryType$values()}.
 }
 \item{\code{setStatus(status)}}{
   Set the imagery plan status, object of class \code{\link{ISOStatus}}
   or 'character' among values given by \code{ISOStatus$values()}.
 }
 \item{\code{setCitation(citation)}}{
   Sets the citation, object of class \code{\link{ISOCitation}}
 }
 \item{\code{addOperation(operation)}}{
   Adds a operation, object of class \code{\link{ISOImageryOperation}}
 }
 \item{\code{delOperation(operation)}}{
   Deletes a operation, object of class \code{\link{ISOImageryOperation}}
 }
 \item{\code{addSatisfiedRequirement(plan)}}{
   Add a satisfied plan, object of class \code{\link{ISOImageryPlan}}
 }
 \item{\code{delSatisfiedRequirement(plan)}}{
   Deletes a satisfied plan, object of class \code{\link{ISOImageryPlan}}
 }
}
}

\examples{
   md <- ISOImageryPlan$new()
   md$setType("point")
   md$setStatus("completed")
   
   #add citation
   rp1 <- ISOResponsibleParty$new()
   rp1$setIndividualName("someone1")
   rp1$setOrganisationName("somewhere1")
   rp1$setPositionName("someposition1")
   rp1$setRole("pointOfContact")
   contact1 <- ISOContact$new()
   phone1 <- ISOTelephone$new()
   phone1$setVoice("myphonenumber1")
   phone1$setFacsimile("myfacsimile1")
   contact1$setPhone(phone1)
   address1 <- ISOAddress$new()
   address1$setDeliveryPoint("theaddress1")
   address1$setCity("thecity1")
   address1$setPostalCode("111")
   address1$setCountry("France")
   address1$setEmail("someone1@theorg.org")
   contact1$setAddress(address1)
   res <- ISOOnlineResource$new()
   res$setLinkage("http://www.somewhereovertheweb.org")
   res$setName("somename")
   contact1$setOnlineResource(res)
   rp1$setContactInfo(contact1)
   
   #citation
   ct <- ISOCitation$new()
   ct$setTitle("sometitle")
   d <- ISODate$new()
   d$setDate(ISOdate(2015, 1, 1, 1))
   d$setDateType("publication")
   ct$addDate(d)
   ct$setEdition("1.0")
   ct$setEditionDate(ISOdate(2015,1,1))
   ct$addIdentifier(ISOMetaIdentifier$new(code = "identifier"))
   ct$addPresentationForm("mapDigital")
   ct$addCitedResponsibleParty(rp1)
   md$setCitation(ct)
   xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{Plan}
\keyword{imagery}
