% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOGeorectified.R
\docType{class}
\name{ISOGeorectified}
\alias{ISOGeorectified}
\title{ISOGeorectified}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Georectified
}
\description{
ISOGeorectified
}
\section{Fields}{

\describe{
\item{\code{checkPointAvailability}}{[\code{\link{logical}}]}

\item{\code{checkPointDescription}}{[\code{\link{character}}]}

\item{\code{cornerPoints}}{[\code{\link{GMLPoint}}]}

\item{\code{centerPoint}}{[\code{\link{GMLPoint}}]}

\item{\code{pointInPixel}}{[\code{\link{ISOPixelOrientation}}]}

\item{\code{transformationDimensionDescription}}{[\code{\link{character}}]}

\item{\code{transformationDimensionMapping}}{[\code{\link{character}}]}
}}

\section{Inherited methods from \code{\link{ISOGridSpatialRepresentation}}}{

\describe{
 \item{\code{setNumberOfDimensions}}{
   Sets the number of dimensions (value of class \code{integer})
 }
 \item{\code{addDimension(dimension)}}{
   Adds a dimension. Object of class \code{\link{ISODimension}}
 }
 \item{\code{delDimension(dimension)}}{
   Deletes a dimension;
 }
 \item{\code{setCellGeometry(cellGeometry)}}{
   Sets the cell geometry. Object of class \code{ISOCellGeometry} or any value
   from \code{ISOCellGeometry$values()}
 }
 \item{\code{setTransformationParameterAvailability(availability)}}{
   Sets the transformation parameter availability
 }
 \item{\code{setPixelOrientation(pixelOrientation)}}{
   Sets the point in pixel orientation, object of class 'character' or \code{\link{ISOPixelOrientation}}
 }
}
}

\section{Methods}{

\describe{
 \item{\code{new(xml,value)}}{
   This method is used to instantiate an \code{\link{ISOGeorectified}}
 }
 \item{\code{setCheckPointAvailability(availability)}}{
   Set checkpoint availability, object of class 'logical' (TRUE/FALSE)
 }
 \item{\code{setCheckPointDescription(description, locales)}}{
   Set checkpoint description
 }
 \item{\code{addCornerPoint(sfg,m)}}{
   Adds a corner point, either an object of class 'sfg' (from \pkg{sf}) or a 'matrix'
 }
 \item{\code{delCornerPoint(sfg,m)}}{
   Deletes a corner point, either an object of class 'sfg' (from \pkg{sf}) or a 'matrix'
 }
 \item{\code{setCenterPoint(sfg,m)}}{
   Sets a center point, either an object of class 'sfg' (from \pkg{sf}) or a 'matrix'
 }
 \item{\code{setTransformationDimensionDescription(description, locales)}}{
   Sets the transformation dimension description.
 }
 \item{\code{addTransformationDimensionMapping(mapping)}}{
   Adds a transformation dimension mapping
 }
 \item{\code{delTransformationDimensionMapping(mapping)}}{
   Deletes a transformation dimension mapping
 }
}
}

\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{georectified}
