% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOFeatureAttribute.R
\docType{class}
\name{ISOFeatureAttribute}
\alias{ISOFeatureAttribute}
\title{ISOFeatureAttribute}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOFeatureAttribute
}
\description{
ISOFeatureAttribute
}
\section{Fields}{

\describe{
\item{\code{code}}{[\code{\link{character}}]}

\item{\code{valueMeasurementUnit}}{[\code{\link{GMLUnitDefinition}}]}

\item{\code{valueType}}{[\code{\link{character}}]}

\item{\code{listedValue}}{[\code{\link{ISOListedValue}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOFeatureAttribute}}
 }
 \item{\code{setCode(code, locales)}}{
   Sets the code. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setValueMeasurementUnit(uom)}}{
   Sets the value measurement unit, an object of class \code{\link{GMLUnitDefinition}}
 }
 \item{\code{setValueType(typeName, locales)}}{
   Sets the value type. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{addListedValue(value)}}{
   Adds a listed value (object of class \code{\link{ISOListedValue})}
 }
 \item{\code{delListedValue(value)}}{
  Deletes a listed value (object of class \code{\link{ISOListedValue})}
 }
}
}

\examples{
  md <- ISOFeatureAttribute$new()
  md$setMemberName("name")
  md$setDefinition("definition")
  md$setCardinality(lower=1,upper=1)
  md$setCode("code")
  
  gml <- GMLBaseUnit$new(id = "ID")
  gml$setDescriptionReference("someref")
  gml$setIdentifier("identifier", "codespace")
  gml$addName("name1", "codespace")
  gml$addName("name2", "codespace")
  gml$setQuantityTypeReference("someref")
  gml$setCatalogSymbol("symbol")
  gml$setUnitsSystem("somelink")
  md$setValueMeasurementUnit(gml)
  
  val1 <- ISOListedValue$new()
  val1$setCode("code1")
  val1$setLabel("label1")
  val1$setDefinition("definition1")
  md$addListedValue(val1)
  val2 <- ISOListedValue$new()
  val2$setCode("code2")
  val2$setLabel("label2")
  val2$setDefinition("definition2")
  md$addListedValue(val2)
  md$setValueType("typeName")
 
}
\references{
ISO 19110:2005 Methodology for Feature cataloguing
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{feature}
\keyword{operation}
