% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INSPIREMetadataValidator.R
\docType{class}
\name{INSPIREMetadataValidator}
\alias{INSPIREMetadataValidator}
\title{INSPIREMetadataValidator}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for setting an INSPIREMetadataValidator
}
\description{
INSPIREMetadataValidator
}
\section{Methods}{

\describe{
 \item{\code{new(url, apiKey)}}{
   This method is used to instantiate an INSPIRE Metadata validator. To check 
   metadata with the INSPIRE metadata validator, a user API key is now required, 
   and should be specified with the \code{apiKey}. By default, the \code{url} will be
   the INSPIRE production service \url{https://inspire.ec.europa.eu/validator/swagger-ui.html}
   
   The \code{keyring_backend} can be set to use a different backend for storing 
   the INSPIRE metadata validator API key with \pkg{keyring} (Default value is 'env').
 }
 \item{\code{uploadFile(path)}}{
   Upload a XML metadata file to INSPIRE web-service. Method called internally through
   \code{getValidationReport}.
 }
 \item{\code{getAPIKey()}}{
   Get the API user key
 }
 \item{\code{getValidationReport(obj, file, raw)}}{
   Get validation report for a metadata specified either as R object of class
   \code{ISOMetadata} (from \pkg{geometa} package) or \code{XMLInternalNode} 
   (from \pkg{XML} package), or as XML file, providing the path of the XML file
   to be sent to the INSPIRE metadata validator web-service. By default, a summary
   report is returned. To append the raw response of INSPIRE validation web-service
   to the summary report, set \code{raw = TRUE}.
 }
}
}

\examples{
 \donttest{
  apiKey <- ""
  if(nzchar(apiKey)){
    inspireValidator <- INSPIREMetadataValidator$new(apiKey = apiKey)
    inspireReport <- inspireValidator$getValidationReport(obj = ISOMetadata$new())
  }
 }

}
\references{
INSPIRE Reference Validator Web Service (https://inspire.ec.europa.eu/validator/swagger-ui.html)
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{INSPIRE}
\keyword{metadata}
\keyword{validation}
\keyword{validator}
